/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.lock;

import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugins.lock.AcquireAllLocksStep;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class DeploymentLockContributor {
    private static final String CONCURRENT_DEPLOYMENTS_ALLOWED_PROPERTY = "allowConcurrentDeployments";

    @Contributor
    public static void addDeploymentLockCheckStep(Deltas deltas, DeploymentPlanningContext ctx) {
        DeployedApplication deployedApplication = ctx.getDeployedApplication();
        Environment environment = deployedApplication.getEnvironment();
        Set<ConfigurationItem> cisToBeLocked = DeploymentLockContributor.checkIfLockingIsRequired(deployedApplication);
        cisToBeLocked.addAll(DeploymentLockContributor.getContainersRequiringCheck(deltas));
        if (!cisToBeLocked.isEmpty()) {
            boolean enableLockRetry = (Boolean)environment.getProperty("enableLockRetry");
            int lockRetryInterval = (Integer)environment.getProperty("lockRetryInterval");
            int lockRetryAttempts = (Integer)environment.getProperty("lockRetryAttempts");
            boolean lockRetryAsync = environment.hasProperty("lockRetryAsync") && (Boolean)environment.getProperty("lockRetryAsync") != false;
            ctx.addStep((Step)new AcquireAllLocksStep(cisToBeLocked, enableLockRetry, lockRetryInterval, lockRetryAttempts, lockRetryAsync));
        }
    }

    private static Set<ConfigurationItem> checkIfLockingIsRequired(DeployedApplication deployedApplication) {
        HashSet<ConfigurationItem> cisToBeLocked = new HashSet<ConfigurationItem>();
        Environment environment = deployedApplication.getEnvironment();
        if (DeploymentLockContributor.shouldLockCI((ConfigurationItem)deployedApplication)) {
            cisToBeLocked.add((ConfigurationItem)deployedApplication);
        }
        if (DeploymentLockContributor.shouldLockCI((ConfigurationItem)environment)) {
            cisToBeLocked.add((ConfigurationItem)environment);
            boolean lockAllContainersInEnvironment = (Boolean)environment.getProperty("lockAllContainersInEnvironment");
            if (lockAllContainersInEnvironment) {
                cisToBeLocked.addAll(environment.getMembers());
            }
        }
        return cisToBeLocked;
    }

    private static boolean shouldLockCI(ConfigurationItem ci) {
        return ci.hasProperty(CONCURRENT_DEPLOYMENTS_ALLOWED_PROPERTY) && Boolean.FALSE.equals(ci.getProperty(CONCURRENT_DEPLOYMENTS_ALLOWED_PROPERTY));
    }

    private static Set<Container> getContainersRequiringCheck(Deltas deltas) {
        return deltas.getDeltas().stream().map(input -> input.getOperation() == Operation.DESTROY ? input.getPrevious().getContainer() : input.getDeployed().getContainer()).filter(input -> input.hasProperty(CONCURRENT_DEPLOYMENTS_ALLOWED_PROPERTY) && Boolean.FALSE.equals(input.getProperty(CONCURRENT_DEPLOYMENTS_ALLOWED_PROPERTY))).collect(Collectors.toSet());
    }
}

