/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.typesafe.config.Config;
import com.xebialabs.deployit.io.copy.CopyUtil;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFolderArtifact;
import com.xebialabs.deployit.plugin.generic.step.BaseDeploymentStep;
import com.xebialabs.deployit.plugin.overthere.CopyStrategyName;
import com.xebialabs.deployit.plugin.overthere.DefaultCopyStrategyName;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.util.StreamFactoryUtil;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.xlplatform.config.ConfigurationHolder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFolderDeploymentStepSupport
extends BaseDeploymentStep {
    private static final Logger logger = LoggerFactory.getLogger(BaseFolderDeploymentStepSupport.class);
    private static final String COPY_STRATEGY_PROPERTY = "copyStrategy";
    private static final List<String> TAR_ARCHIVE_TYPES = Arrays.asList("tar", "tar.gz", "tar.bz2");

    protected BaseFolderDeploymentStepSupport() {
    }

    protected BaseFolderDeploymentStepSupport(int order, String description, HostContainer container) {
        super(order, description, container);
    }

    protected BaseFolderDeploymentStepSupport(int order, HostContainer container) {
        super(order, (String)null, container);
    }

    abstract BaseDeployableFolderArtifact getBaseDeployableFolderArtifact();

    protected final boolean isDeployableFolderArtifact() {
        return this.getBaseDeployableFolderArtifact() != null;
    }

    protected final boolean isForceArchivedForFolder() {
        boolean isForceArchive;
        BaseDeployableFolderArtifact baseDeployableFolderArtifact = this.getBaseDeployableFolderArtifact();
        if (baseDeployableFolderArtifact != null) {
            isForceArchive = baseDeployableFolderArtifact.isForceArchive();
            logger.debug("baseDeployableFolderArtifact is not NULL, forceArchive: {}", (Object)isForceArchive);
        } else {
            logger.debug("baseDeployableFolderArtifact is NULL, skipping force archive check.");
            isForceArchive = false;
        }
        return isForceArchive;
    }

    protected final boolean isOneByOneCopyStrategy() {
        Host host = this.container.getHost();
        boolean hasCopyStrategy = host.hasProperty(COPY_STRATEGY_PROPERTY);
        CopyStrategyName strategy = hasCopyStrategy ? (CopyStrategyName)host.getProperty(COPY_STRATEGY_PROPERTY) : null;
        boolean isOneByOne = hasCopyStrategy && CopyStrategyName.OneByOne.equals((Object)strategy);
        boolean isOneByOneDerived = isOneByOne || strategy == null && this.isAutoDetect() == false && this.isDefaultStrategyFallBackToOneByOne() != false;
        logger.debug("[isOneByOneCopyStrategy] hasCopyStrategy: {}, strategy: {}, isOneByOneFromHost: {}, isOneByOneDerived: {}", new Object[]{hasCopyStrategy, strategy, isOneByOne, isOneByOneDerived});
        return isOneByOneDerived;
    }

    protected final boolean isFolderCanBeDeletedRecursive() {
        Host host = this.container.getHost();
        if (host.getOs() != null && !OperatingSystemFamily.WINDOWS.equals((Object)host.getOs())) {
            SshConnectionType connectionType = (SshConnectionType)host.getProperty("connectionType");
            return SshConnectionType.SCP.equals((Object)connectionType) || SshConnectionType.SU.equals((Object)connectionType) || SshConnectionType.SUDO.equals((Object)connectionType) || SshConnectionType.INTERACTIVE_SUDO.equals((Object)connectionType);
        }
        logger.debug("[isSshHostAndNotSftp] Host OS is Windows or not set, skipping SSH/SFTP check.");
        return false;
    }

    protected final CopyStrategyName getCopyStrategyName(String srcFileName) {
        Host host = this.container.getHost();
        boolean hasCopyStrategy = host.hasProperty(COPY_STRATEGY_PROPERTY);
        CopyStrategyName strategy = null;
        if (hasCopyStrategy) {
            strategy = (CopyStrategyName)host.getProperty(COPY_STRATEGY_PROPERTY);
        }
        if (strategy == null) {
            if (this.isAutoDetect().booleanValue()) {
                strategy = this.getAutoDetectCopyStrategyName(srcFileName);
                logger.debug("[getCopyStrategyName] Auto-detected strategy: {}", (Object)strategy);
            } else {
                strategy = this.mapDefaultToCopyStrategyName(this.getDefaultCopyStrategyNameFromArtifact(), this.container.getHost());
                logger.debug("[getCopyStrategyName] copy strategy found, using default strategy: {}", (Object)strategy);
            }
        }
        logger.debug("[getCopyStrategyName] srcFileName: {}, hasCopyStrategy: {}, strategy: {}", new Object[]{srcFileName, hasCopyStrategy, strategy});
        return strategy;
    }

    private CopyStrategyName getAutoDetectCopyStrategyName(String srcFileName) {
        try {
            String archiveType;
            switch (archiveType = StreamFactoryUtil.fetchStreamFactory().getArchiveType(srcFileName)) {
                case "tar": 
                case "tar.gz": 
                case "tar.bz2": {
                    return CopyStrategyName.Tar;
                }
                case "zip": 
                case "jar": {
                    OperatingSystemFamily os = this.container.getHost().getOs();
                    if (OperatingSystemFamily.WINDOWS.equals((Object)os)) {
                        return CopyStrategyName.ZipWindows;
                    }
                    if (OperatingSystemFamily.UNIX.equals((Object)os) || OperatingSystemFamily.ZOS.equals((Object)os)) {
                        return CopyStrategyName.ZipUnix;
                    }
                    logger.warn("folder:deploy:archiveType not recognized for file {}. Falling back to default strategy.", (Object)srcFileName);
                    return this.mapDefaultToCopyStrategyName(this.getDefaultCopyStrategyNameFromArtifact(), this.container.getHost());
                }
            }
            return this.mapDefaultToCopyStrategyName(this.getDefaultCopyStrategyNameFromArtifact(), this.container.getHost());
        }
        catch (Exception ex) {
            logger.warn("Exception occurred while detecting copy strategy for file: {}. Falling back to default strategy.", (Object)srcFileName, (Object)ex);
            return this.mapDefaultToCopyStrategyName(this.getDefaultCopyStrategyNameFromArtifact(), this.container.getHost());
        }
    }

    private Boolean isDefaultStrategyFallBackToOneByOne() {
        DefaultCopyStrategyName defaultCopyStrategyName = this.getDefaultCopyStrategyNameFromArtifact();
        return DefaultCopyStrategyName.OneByOne.equals((Object)defaultCopyStrategyName);
    }

    private CopyStrategyName getDefaultCopyStrategyName(CopyStrategyName detectedCopyStrategyName) {
        if (this.isAutoDetect().booleanValue()) {
            return detectedCopyStrategyName;
        }
        return this.mapDefaultToCopyStrategyName(this.getDefaultCopyStrategyNameFromArtifact(), this.container.getHost());
    }

    private DefaultCopyStrategyName getDefaultCopyStrategyNameFromArtifact() {
        BaseDeployableFolderArtifact artifact = this.getBaseDeployableFolderArtifact();
        logger.debug("[getDefaultCopyStrategyNameFromArtifact] Called for artifact: {}", (Object)(artifact != null ? artifact.getId() : null));
        BaseDeployableFolderArtifact deployable = this.getBaseDeployableFolderArtifact();
        if (deployable != null) {
            if (deployable.getDefaultCopyStrategy() != null && deployable.hasProperty("defaultCopyStrategy")) {
                DefaultCopyStrategyName defaultName = (DefaultCopyStrategyName)deployable.getDefaultCopyStrategy().getProperty("defaultCopyStrategy");
                logger.debug("[getDefaultCopyStrategyNameFromArtifact] Found defaultCopyStrategy property: {}", (Object)defaultName);
                return defaultName;
            }
            logger.debug("[getDefaultCopyStrategyNameFromArtifact] No defaultCopyStrategy property found on deployable: {}", (Object)deployable.getId());
        } else {
            logger.debug("[getDefaultCopyStrategyNameFromArtifact] Deployable is not BaseDeployableFolderArtifact");
        }
        logger.debug("[getDefaultCopyStrategyNameFromArtifact] Returning default: {}", (Object)DefaultCopyStrategyName.OneByOne);
        return DefaultCopyStrategyName.OneByOne;
    }

    private Boolean isAutoDetect() {
        boolean allowDetect;
        Map backupConfig = (Map)this.getCtx().getAttribute("config");
        String autodetectSetting = "deploy.task.artifact-copy-strategy.autodetect";
        Config config = ConfigurationHolder.get();
        if (config == null) {
            logger.debug("[isAutoDetect] config is null, using backupConfig for autodetect setting");
            allowDetect = Boolean.parseBoolean(backupConfig.getOrDefault(autodetectSetting, "false"));
            logger.debug("[isAutoDetect] autodetect from backupConfig: {}", (Object)allowDetect);
        } else {
            allowDetect = config.getBoolean(autodetectSetting);
            logger.debug("[isAutoDetect] autodetect from config: {}", (Object)allowDetect);
        }
        logger.debug("[isAutoDetect] Returning: {}", (Object)allowDetect);
        return allowDetect;
    }

    private CopyStrategyName mapDefaultToCopyStrategyName(DefaultCopyStrategyName defaultName, Host host) {
        CopyStrategyName result = defaultName == null ? CopyStrategyName.OneByOne : (defaultName == DefaultCopyStrategyName.OneByOne ? CopyStrategyName.OneByOne : (defaultName == DefaultCopyStrategyName.Zip ? (host != null && host.getOs() != null && OperatingSystemFamily.WINDOWS.equals((Object)host.getOs()) ? CopyStrategyName.ZipWindows : CopyStrategyName.ZipUnix) : (defaultName == DefaultCopyStrategyName.Tar ? CopyStrategyName.Tar : CopyStrategyName.OneByOne)));
        logger.debug("[mapDefaultToCopyStrategyName] Mapping DefaultCopyStrategyName '{}' with host OS '{}' to CopyStrategyName '{}'", new Object[]{defaultName, host != null ? host.getOs() : null, result});
        return result;
    }

    protected LocalFile folderAsTar(LocalFile localFile) {
        if (this.isForceArchivedForFolder()) {
            return CopyUtil.zipWithDirectoryAndExcludeRootDir((CopyStrategyName)CopyStrategyName.Tar, (LocalFile)localFile);
        }
        return CopyUtil.zipWithDirectoryAndRootDir((CopyStrategyName)CopyStrategyName.Tar, (LocalFile)localFile);
    }
}

