package com.xebialabs.deployit.plugin.generic.freemarker;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.plugin.freemarker.sanitizer.OSScriptSanitizer;

public abstract class OSScriptSanitizerWrapper {

    private OSScriptSanitizerWrapper() {}

    public static Object addScriptSanitizers(Object context) {
        if (context instanceof Map) {
            Map <String, Object> m = new HashMap((Map)context);
            m.put(OSScriptSanitizer.SANITIZE_EXPRESSION_UNIX(),
                    OSScriptSanitizer.createUnixSpecificSanitizer());
            m.put(OSScriptSanitizer.SANITIZE_EXPRESSION_WINDOWS(),
                    OSScriptSanitizer.createWindowsSpecificSanitizer());
            return Collections.unmodifiableMap(m);
        }
        return context;
    }

    public static Object addScriptSanitizers(String templatePath, Object context) {
        if (context instanceof Map) {
            Map <String, Object> m = new HashMap((Map)context);
            m.put(OSScriptSanitizer.SANITIZE_EXPRESSION_AUTO(),
                    OSScriptSanitizer.createOSSpecificSanitizer(templatePath));
            return Collections.unmodifiableMap(m);
        }
        return context;
    }
}
