/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StageableStep;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.flow.StagingContext;
import com.xebialabs.deployit.plugin.api.flow.StagingTarget;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.context.PreviewExecutionContext;
import com.xebialabs.deployit.plugin.generic.freemarker.ArtifactUploader;
import com.xebialabs.deployit.plugin.generic.step.BaseStep;
import com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.remoting.preview.PreviewOverthereConnection;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class BaseExecutionStep
extends BaseStep
implements PreviewStep,
StageableStep {
    private static final Logger logger = LoggerFactory.getLogger(BaseExecutionStep.class);
    private static final String MDC_KEY_SCRIPT_PATH = "scriptPath";
    private String scriptTemplatePath;
    private Map<String, Object> stepVariables;
    private File file;
    private DerivedArtifact derivedArtifact;
    private StagedFile stagedDerivedArtifact;
    private List<File> fileResources = Lists.newArrayList();
    private List<String> classpathResources = Lists.newArrayList();
    private List<String> templateClasspathResources = Lists.newArrayList();
    private Preview preview;
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.generic.scripts");

    public BaseExecutionStep() {
        this.stepVariables = Maps.newHashMap();
    }

    public BaseExecutionStep(String scriptPath, HostContainer container, Map<String, Object> vars, String description) {
        this(null, scriptPath, container, vars, description);
    }

    public BaseExecutionStep(Integer order, String scriptPath, HostContainer container, Map<String, Object> vars, String description) {
        super(order, description, container);
        this.scriptTemplatePath = scriptPath;
        this.stepVariables = Maps.newHashMap(vars);
        Objects.requireNonNull(this.scriptTemplatePath);
    }

    public void requestStaging(StagingContext ctx) {
        if (this.derivedArtifact != null) {
            logger.debug("[{}] is requesting staging of [{}]", (Object)this, (Object)this.derivedArtifact);
            this.stagedDerivedArtifact = ctx.stageArtifact((Artifact)this.derivedArtifact, (StagingTarget)this.container.getHost());
        } else {
            logger.debug("[{}] is not requesting artifact staging.", (Object)this);
        }
    }

    @Override
    public StepExitCode doExecute() throws Exception {
        MDC.put((String)MDC_KEY_SCRIPT_PATH, (String)this.scriptTemplatePath);
        try {
            this.uploadArtifactIfPresent();
            this.uploadFileResources();
            this.uploadClasspathResources();
            this.uploadTemplateClasspathResources();
            OverthereFile executable = this.uploadScriptToExecute(this.scriptTemplatePath);
            this.setWorkingDirectory();
            StepExitCode stepExitCode = this.executeScript(executable);
            return stepExitCode;
        }
        finally {
            MDC.remove((String)MDC_KEY_SCRIPT_PATH);
        }
    }

    public Preview getPreview() {
        if (this.preview == null) {
            this.ctx = new PreviewExecutionContext();
            this.getLocalConnection();
            this.remoteConn = PreviewOverthereConnection.getPreviewConnection();
            try {
                String sourcePath = this.resolveOsSpecificTemplate(this.scriptTemplatePath);
                String contents = this.evaluateTemplate(sourcePath, this.stepVariables, true);
                this.preview = Preview.withSourcePathAndContents((String)sourcePath, (String)contents);
            }
            finally {
                this.ctx = null;
                this.disconnect();
            }
        }
        return this.preview;
    }

    protected OverthereFile uploadArtifactIfPresent() {
        if (this.file != null) {
            return this.uploadToWorkingDirectory(this.file, this.file.getName());
        }
        return null;
    }

    protected void uploadFileResources() {
        for (File fileResource : this.fileResources) {
            this.uploadToWorkingDirectory(fileResource, fileResource.getName());
        }
    }

    protected void uploadClasspathResources() {
        for (String cpResource : this.classpathResources) {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(cpResource);
            Checks.checkArgument((resource != null ? 1 : 0) != 0, (String)"resource %s not found.", (Object[])new Object[]{cpResource});
            try {
                TFile resourceFile = new TFile(resource.toURI());
                this.uploadFileOrDirectory(this.getRemoteWorkingDirectory(), resourceFile, true);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
    }

    protected void uploadFileOrDirectory(OverthereFile remoteDir, TFile file, boolean logFileNameToConsole) throws IOException {
        if (file.isFile() && !file.isDirectory()) {
            if (logFileNameToConsole) {
                this.getCtx().logOutput("Uploading file " + file.getName() + " to working directory.");
            }
            OverthereFile targetFile = remoteDir.getFile(file.getName());
            try (TFileInputStream is = new TFileInputStream((File)file);){
                OverthereUtils.write((InputStream)is, (OverthereFile)targetFile);
            }
        } else {
            OverthereFile targetDir;
            if (logFileNameToConsole) {
                this.getCtx().logOutput("Uploading directory " + file.getName() + " to working directory.");
            }
            if (!(targetDir = remoteDir.getFile(file.getName())).exists()) {
                targetDir.mkdir();
            }
            for (TFile childFile : file.listFiles(TArchiveDetector.NULL)) {
                this.uploadFileOrDirectory(targetDir, childFile, false);
            }
        }
    }

    protected void uploadTemplateClasspathResources() {
        for (String cpTemplate : this.templateClasspathResources) {
            this.uploadTemplateResourceToWorkingDirectory(cpTemplate);
        }
    }

    private OverthereFile uploadTemplateResourceToWorkingDirectory(String template) {
        String osSpecificTemplate = this.resolveOsSpecificTemplate(template);
        String content = this.evaluateTemplate(osSpecificTemplate, this.stepVariables, false);
        String fileName = this.resolveOsSpecificFileName(osSpecificTemplate);
        return this.uploadToWorkingDirectory(content, fileName);
    }

    protected OverthereFile uploadScriptToExecute(String scriptTemplatePath) {
        String osSpecificTemplate = this.resolveOsSpecificTemplate(scriptTemplatePath);
        String generatedScript = this.evaluateTemplate(osSpecificTemplate, this.stepVariables, false);
        if (scriptsLogger.isTraceEnabled()) {
            String obfuscatedScript = this.evaluateTemplate(osSpecificTemplate, this.stepVariables, true);
            ScriptUtils.dumpScript((String)scriptTemplatePath, (String)obfuscatedScript, (Logger)scriptsLogger);
        }
        String fileName = this.resolveOsSpecificFileName(osSpecificTemplate);
        return this.uploadToWorkingDirectory(generatedScript, fileName);
    }

    protected void setWorkingDirectory() {
        this.getRemoteConnection().setWorkingDirectory(this.getRemoteWorkingDirectory());
    }

    protected StepExitCode executeScript(OverthereFile executable) {
        executable.setExecutable(true);
        CmdLine cmdLine = CmdLine.build((String[])new String[]{executable.getPath()});
        try (DefaultExecutionOutputHandler stdoutHandler = DefaultExecutionOutputHandler.handleStdout((ExecutionContext)this.getCtx());){
            StepExitCode stepExitCode;
            block16: {
                DefaultExecutionOutputHandler stderrHandler;
                block14: {
                    StepExitCode stepExitCode2;
                    block15: {
                        stderrHandler = DefaultExecutionOutputHandler.handleStderr((ExecutionContext)this.getCtx());
                        try {
                            this.getCtx().logOutput("Executing " + executable.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
                            int rc = this.getRemoteConnection().execute((OverthereExecutionOutputHandler)stdoutHandler, (OverthereExecutionOutputHandler)stderrHandler, cmdLine);
                            if (rc == 0) break block14;
                            this.getCtx().logError("Execution failed with return code " + rc);
                            stepExitCode2 = StepExitCode.FAIL;
                            if (stderrHandler == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (stderrHandler != null) {
                                try {
                                    stderrHandler.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stderrHandler.close();
                    }
                    return stepExitCode2;
                }
                stepExitCode = StepExitCode.SUCCESS;
                if (stderrHandler == null) break block16;
                stderrHandler.close();
            }
            return stepExitCode;
        }
    }

    public DerivedArtifact getDerivedArtifact() {
        return this.derivedArtifact;
    }

    public String getScriptPath() {
        return this.scriptTemplatePath;
    }

    public List<File> getFileResources() {
        return this.fileResources;
    }

    public void setFileResources(List<File> fileResources) {
        this.fileResources = fileResources;
    }

    public List<String> getClasspathResources() {
        return this.classpathResources;
    }

    public void setClasspathResources(List<String> classpathResources) {
        this.classpathResources = classpathResources;
    }

    public List<String> getTemplateClasspathResources() {
        return this.templateClasspathResources;
    }

    public void setTemplateClasspathResources(List<String> templateClasspathResources) {
        this.templateClasspathResources = templateClasspathResources;
    }

    public File getArtifact() {
        return this.file;
    }

    @Deprecated
    public void setArtifact(File artifact) {
        this.file = artifact;
    }

    public void setDerivedArtifact(DerivedArtifact da) {
        this.derivedArtifact = da;
    }

    public String getUploadedArtifactPath() {
        if (this.file != null) {
            return this.getRemoteWorkingDirectory().getPath() + this.getContainer().getHost().getOs().getFileSeparator() + this.file.getName();
        }
        if (this.derivedArtifact != null) {
            WorkingFolderUploader uploader = (WorkingFolderUploader)this.getArtifactUploader();
            String path = uploader.lookup((Artifact)this.derivedArtifact);
            return path == null ? "" : path;
        }
        return "";
    }

    protected String resolveOsSpecificFileName(String template) {
        return BaseExecutionStep.resolveOsSpecificFileName(template, this.getContainer());
    }

    public static String resolveOsSpecificFileName(String template, HostContainer hostContainer) {
        String fileExt;
        Object osSpecificFile = BaseExecutionStep.substringAfterLast(template, '/', template);
        if (((String)osSpecificFile).endsWith(".ftl")) {
            osSpecificFile = ((String)osSpecificFile).substring(0, ((String)osSpecificFile).lastIndexOf(".ftl"));
        }
        if ((fileExt = BaseExecutionStep.substringAfterLast((String)osSpecificFile, '.')) == null) {
            OperatingSystemFamily os = hostContainer.getHost().getOs();
            osSpecificFile = (String)osSpecificFile + os.getScriptExtension();
        }
        return osSpecificFile;
    }

    @Override
    protected ArtifactUploader createArtifactUploader() {
        return new WorkingFolderUploader(this.getCtx());
    }

    @VisibleForTesting
    public String getScriptTemplatePath() {
        return this.getScriptPath();
    }

    @VisibleForTesting
    public Map<String, Object> getVars() {
        return this.stepVariables;
    }

    private class WorkingFolderUploader
    implements ArtifactUploader {
        private Map<ArtifactCacheKey, String> uploadedFiles = Maps.newHashMap();
        private ExecutionContext ctx;

        public WorkingFolderUploader(ExecutionContext ctx) {
            this.ctx = ctx;
        }

        public String lookup(Artifact artifact) {
            return this.uploadedFiles.get(new ArtifactCacheKey(this, artifact));
        }

        @Override
        public String upload(Artifact artifact) {
            String path;
            ArtifactCacheKey artifactKey = new ArtifactCacheKey(this, artifact);
            if (this.uploadedFiles.containsKey(artifactKey)) {
                return this.uploadedFiles.get(artifactKey);
            }
            logger.trace("Requesting upload of artifact [{}]", (Object)artifact);
            logger.trace("Derived artifact = [{}]", (Object)BaseExecutionStep.this.derivedArtifact);
            if (BaseExecutionStep.this.derivedArtifact != null && BaseExecutionStep.this.stagedDerivedArtifact != null && artifact == BaseExecutionStep.this.derivedArtifact) {
                logger.debug("Retrieving result of staging for artifact [{}]", (Object)BaseExecutionStep.this.derivedArtifact);
                OverthereFile uploadedDerivedArtifact = BaseExecutionStep.this.stagedDerivedArtifact.get(BaseExecutionStep.this.getRemoteConnection(), this.ctx);
                OverthereFile dir = BaseExecutionStep.this.getRemoteWorkingDirectory();
                this.ctx.logOutput("Copying " + this.getFileType(uploadedDerivedArtifact) + " " + uploadedDerivedArtifact.getName() + " to working directory.");
                uploadedDerivedArtifact.copyTo(dir.getFile(uploadedDerivedArtifact.getName()));
                path = dir.getFile(uploadedDerivedArtifact.getName()).getPath();
            } else {
                OverthereFile dir = OverthereUtils.getUniqueFolder((OverthereFile)BaseExecutionStep.this.getRemoteWorkingDirectory(), (String)artifact.getName());
                OverthereFile uploadedFile = dir.getFile(artifact.getName());
                if (!uploadedFile.exists()) {
                    OverthereFile artifactFile = artifact.getFile();
                    String fileType = this.getFileType(artifactFile);
                    this.ctx.logOutput("Uploading " + fileType + " " + artifact.getName() + " to working directory.");
                    artifactFile.copyTo(uploadedFile);
                } else {
                    logger.warn("Not uploading file " + artifact.getName() + " to working directory again because it has already been uploaded.");
                }
                path = uploadedFile.getPath();
            }
            this.uploadedFiles.put(artifactKey, path);
            return path;
        }

        private String getFileType(OverthereFile file) {
            return file.isDirectory() ? "directory" : "file";
        }

        private class ArtifactCacheKey {
            Artifact artifact;

            public ArtifactCacheKey(WorkingFolderUploader workingFolderUploader, Artifact artifact) {
                this.artifact = artifact;
            }

            public int hashCode() {
                return 1;
            }

            public boolean equals(Object obj) {
                return obj instanceof ArtifactCacheKey && ((ArtifactCacheKey)obj).artifact == this.artifact;
            }
        }
    }
}

