/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;

@Metadata(description="Abstract deployed that can target any artifact to a generic container")
public abstract class AbstractDeployedArtifact<D extends Deployable>
extends AbstractDeployed<D> {
    @Property(hidden=true, description="Path to which artifact must be copied to on the generic server.")
    private String targetDirectory;
    @Property(hidden=true, defaultValue="true", description="Is the target directory shared by others on the generic server. When true, the target directory is not deleted during a destroy operation; only the artifacts copied to it.", required=false)
    private boolean targetDirectoryShared;
    @Property(hidden=true, defaultValue="false", description="Create the target directory on the generic server if it does not exist.", required=false)
    private boolean createTargetDirectory;
    @Property(required=false, description="Name of the artifact on the generic server.")
    private String targetFile;

    protected String resolveTargetFileName() {
        return Strings.nullToEmpty((String)this.getTargetFile()).trim().isEmpty() ? this.getDeployable().getName() : this.getTargetFile();
    }

    public String getTargetDirectory() {
        return this.resolveExpression(this.targetDirectory);
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public boolean isTargetDirectoryShared() {
        return this.targetDirectoryShared;
    }

    public void setTargetDirectoryShared(boolean targetDirectoryShared) {
        this.targetDirectoryShared = targetDirectoryShared;
    }

    public boolean isCreateTargetDirectory() {
        return this.createTargetDirectory;
    }

    public void setCreateTargetDirectory(boolean createTargetDirectory) {
        this.createTargetDirectory = createTargetDirectory;
    }

    public String getTargetFile() {
        return this.resolveExpression(this.targetFile);
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }
}

