/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.local.message.ProductName;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.ITask;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.generic.step.BaseExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectScriptExecutionStep
extends BaseExecutionStep {
    private static final String defaultEncoding = "UTF-8";
    protected ConfigurationItem inspectedItem;
    public static final String INSPECTED_PROPERTY_PRELUDE = "INSPECTED:";
    public static final String DISCOVERED_ITEM_PRELUDE = "DISCOVERED:";

    public InspectScriptExecutionStep(ConfigurationItem inspectedItem, String scriptPath, HostContainer container, Map<String, Object> vars, String description) {
        super(50, scriptPath, container, vars, description);
        this.inspectedItem = inspectedItem;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(InspectScriptExecutionStep.class);
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return this.handleExecute(new InspectionProtocolContext(ctx));
    }

    protected boolean handleOutputLine(String line, ExecutionContext ctx) {
        int posOfEqualsSign = line.indexOf(61);
        if (posOfEqualsSign < 0) {
            return false;
        }
        try {
            if (line.startsWith(INSPECTED_PROPERTY_PRELUDE)) {
                String name = URLDecoder.decode(line.substring(INSPECTED_PROPERTY_PRELUDE.length(), posOfEqualsSign), defaultEncoding);
                String value = line.substring(posOfEqualsSign + 1);
                return this.handleInspectedProperty(name, value, ctx);
            }
            if (line.startsWith(DISCOVERED_ITEM_PRELUDE)) {
                String id = URLDecoder.decode(line.substring(DISCOVERED_ITEM_PRELUDE.length(), posOfEqualsSign), defaultEncoding);
                String typeName = line.substring(posOfEqualsSign + 1);
                return this.handleDiscoveredItem(id, typeName, ctx);
            }
        }
        catch (UnsupportedEncodingException encodingException) {
            this.getLogger().debug("Unsupported encoding exception was encountered while parsing inspected and / or discovered items");
            return false;
        }
        return false;
    }

    private boolean handleInspectedProperty(String name, String value, ExecutionContext ctx) throws UnsupportedEncodingException {
        PropertyDescriptor pd = this.inspectedItem.getType().getDescriptor().getPropertyDescriptor(name);
        if (pd == null) {
            ctx.logError("Inspected unknown property " + name);
            return false;
        }
        if (pd.getKind() == PropertyKind.SET_OF_CI) {
            HashSet refs = Sets.newHashSet(InspectScriptExecutionStep.getCis(value, pd));
            pd.set(this.inspectedItem, (Object)refs);
        } else if (pd.getKind() == PropertyKind.SET_OF_STRING) {
            HashSet stringProperties = Sets.newHashSet(InspectScriptExecutionStep.getStrings(value));
            pd.set(this.inspectedItem, (Object)stringProperties);
        } else if (pd.getKind() == PropertyKind.LIST_OF_CI) {
            ArrayList refs = Lists.newArrayList(InspectScriptExecutionStep.getCis(value, pd));
            pd.set(this.inspectedItem, (Object)refs);
        } else if (pd.getKind() == PropertyKind.LIST_OF_STRING) {
            ArrayList stringProperties = Lists.newArrayList(InspectScriptExecutionStep.getStrings(value));
            pd.set(this.inspectedItem, (Object)stringProperties);
        } else if (pd.getKind() == PropertyKind.MAP_STRING_STRING) {
            HashMap mapProperties = Maps.newHashMap();
            for (String property : value.split(",")) {
                if (!property.contains(":")) continue;
                String[] keyValue = property.split(":");
                mapProperties.put(URLDecoder.decode(keyValue[0], defaultEncoding), URLDecoder.decode(keyValue[1], defaultEncoding));
            }
            pd.set(this.inspectedItem, (Object)mapProperties);
        } else {
            pd.set(this.inspectedItem, (Object)URLDecoder.decode(value, defaultEncoding));
        }
        this.getLogger().debug("Inspected property {} with value {}", (Object)name, (Object)value);
        return true;
    }

    private static Collection<String> getStrings(String value) throws UnsupportedEncodingException {
        ArrayList stringProperties = Lists.newArrayList();
        if (value.length() > 0) {
            for (String property : value.split(",")) {
                stringProperties.add(URLDecoder.decode(property, defaultEncoding));
            }
        }
        return stringProperties;
    }

    private static Collection<ConfigurationItem> getCis(String value, PropertyDescriptor pd) throws UnsupportedEncodingException {
        ArrayList refs = Lists.newArrayList();
        if (value.length() > 0) {
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)pd.getReferencedType());
            for (String id : value.split(",")) {
                ConfigurationItem ref = descriptor.newInstance(URLDecoder.decode(id, defaultEncoding));
                refs.add(ref);
            }
        }
        return refs;
    }

    private boolean handleDiscoveredItem(String id, String typeName, ExecutionContext ctx) throws UnsupportedEncodingException {
        Type type = Type.valueOf((String)URLDecoder.decode(typeName, defaultEncoding));
        if (!DescriptorRegistry.exists((Type)type)) {
            ctx.logError("Discovered item " + id + " of unknown type " + type);
            return false;
        }
        Descriptor d = DescriptorRegistry.getDescriptor((Type)type);
        ConfigurationItem discoveredItem = d.newInstance(id);
        for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
            if (!this.isReferenceToParent(pd)) continue;
            pd.set(discoveredItem, (Object)this.inspectedItem);
        }
        ctx.getInspectionContext().discovered(discoveredItem);
        this.getLogger().debug("Discovered item {} with type {}", (Object)id, (Object)type);
        return true;
    }

    protected boolean isReferenceToParent(PropertyDescriptor pd) {
        return pd.getKind() == PropertyKind.CI && pd.isAsContainment() && this.inspectedItem.getType().getDescriptor().isAssignableTo(pd.getReferencedType());
    }

    private class InspectionProtocolContext
    implements ExecutionContext {
        private final ExecutionContext context;

        public InspectionProtocolContext(ExecutionContext context) {
            this.context = context;
        }

        public void logOutput(String output) {
            if (InspectScriptExecutionStep.this.handleOutputLine(output, this.context)) {
                InspectScriptExecutionStep.this.getLogger().trace("Handled inspection protocol line {}", (Object)output);
            } else {
                this.context.logOutput(output);
            }
        }

        public void logMsgOutput(ProductName productName, String key, Object ... args) {
            String output = this.getMessage(productName, key, args);
            if (InspectScriptExecutionStep.this.handleOutputLine(output, this.context)) {
                InspectScriptExecutionStep.this.getLogger().trace("Handled inspection protocol line {}", (Object)output);
            } else {
                this.context.logOutput(output);
            }
        }

        public void logError(String error) {
            this.context.logError(error);
        }

        public void logError(String error, Throwable t) {
            this.context.logError(error, t);
        }

        public Object getAttribute(String name) {
            return this.context.getAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.context.setAttribute(name, value);
        }

        public Repository getRepository() {
            return this.context.getRepository();
        }

        public InspectionContext getInspectionContext() {
            return this.context.getInspectionContext();
        }

        public ITask getTask() {
            return this.context.getTask();
        }
    }
}

