/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.file.step;

import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider;
import com.xebialabs.deployit.checksum.DefaultChecksumAlgorithmProviderFactory;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArtifact;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.io.StreamerFactory;
import com.xebialabs.xldeploy.packager.placeholders.PlaceholdersUtil;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class RescanArtifactStep
implements Step {
    private final BaseDeployableArtifact artifact;

    public RescanArtifactStep(BaseDeployableArtifact artifact) {
        this.artifact = artifact;
    }

    public int getOrder() {
        return 10;
    }

    public String getDescription() {
        return "Rescan artifact " + this.artifact;
    }

    public StepExitCode execute(ExecutionContext ctx) {
        SourceArtifactScanner scanner = new SourceArtifactScanner(StreamerFactory.defaultMappings());
        ChecksumAlgorithmProvider checksumAlgorithmProvider = DefaultChecksumAlgorithmProviderFactory.defaultComparisonAlgorithm();
        try {
            if (!PlaceholdersUtil.SourceArtifactUtil((SourceArtifact)this.artifact).shouldScanPlaceholders()) {
                ctx.logError("Should not rescan artifact " + this.artifact + ". This CI or doesn't have property `scanPlaceholders` or it is not enabled.");
                return StepExitCode.FAIL;
            }
            String oldChecksum = this.artifact.getChecksum();
            if (!this.artifact.getFileUri().startsWith("internal:")) {
                this.rescanExternalArtifact(scanner, checksumAlgorithmProvider);
            } else {
                ResolvedArtifactFile resolved = ArtifactResolverRegistry.resolve((SourceArtifact)this.artifact);
                String fileName = this.getFileName();
                PlaceholdersUtil.SourceArtifactUtil((SourceArtifact)this.artifact).rescan(scanner, fileName, resolved.openStream(), () -> ((ChecksumAlgorithmProvider)checksumAlgorithmProvider).getMessageDigest());
            }
            this.artifact.setRescanned(true);
            ctx.getRepository().update((ConfigurationItem[])new BaseDeployableArtifact[]{this.artifact});
            ctx.logOutput("Successfully re-scanned placeholders " + this.artifact.getPlaceholders() + " for artifact " + this.artifact + ".");
            return StepExitCode.SUCCESS;
        }
        catch (Exception exc) {
            ctx.logError("Cannot rescan artifact " + this.artifact + ". Please check settings.", (Throwable)exc);
            return StepExitCode.FAIL;
        }
    }

    private void rescanExternalArtifact(SourceArtifactScanner scanner, ChecksumAlgorithmProvider checksumAlgorithmProvider) throws IOException {
        ArtifactFileUtils.checkFileConditions((SourceArtifact)this.artifact);
        if (ArtifactFileUtils.hasRealOrResolvedFile((Artifact)this.artifact)) {
            PlaceholdersUtil.SourceArtifactUtil((SourceArtifact)this.artifact).rescan(scanner, () -> ((ChecksumAlgorithmProvider)checksumAlgorithmProvider).getMessageDigest());
        } else {
            ResolvedArtifactFile resolved = ArtifactResolverRegistry.resolve((SourceArtifact)this.artifact);
            PlaceholdersUtil.SourceArtifactUtil((SourceArtifact)this.artifact).rescan(scanner, resolved.getFileName(), resolved.openStream(), () -> ((ChecksumAlgorithmProvider)checksumAlgorithmProvider).getMessageDigest());
            this.artifact.setFile(LocalFile.valueOf((File)new File(resolved.getFileName())));
        }
    }

    private boolean isChecksumDifferent(String oldChecksum, String newChecksum) {
        return !oldChecksum.equals(newChecksum);
    }

    private String getFileName() throws URISyntaxException {
        URI uri = new URI(this.artifact.getFileUri());
        switch (uri.getScheme()) {
            case "http": 
            case "https": {
                return uri.getPath().substring(uri.getPath().lastIndexOf("/") + 1);
            }
        }
        return uri.getSchemeSpecificPart();
    }
}

