package com.xebialabs.deployit.plugins.releaseauth.verification;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.reflect.*;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Verify(clazz = RequiresPropertyVerification.Verification.class, type = "requiresProperties")
public @interface RequiresPropertyVerification {

    public static class Verification implements TypeVerification {
        @Override
        public void verify(final Descriptor descriptor, final VerificationContext context) {
            for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                if (propertyDescriptor.getName().startsWith("requires") && propertyDescriptor.getKind() != PropertyKind.BOOLEAN) {
                    context.error("Property [%s] is a release condition, but is not of type boolean", propertyDescriptor.getName());
                }
            }
        }
    }
}
