/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cmd.whitelist.validator;

import com.xebialabs.deployit.engine.tasker.query.QueryExecutorHandler;
import com.xebialabs.deployit.engine.tasker.query.RemoteServerQueryHandler;
import com.xebialabs.deployit.plugin.cmd.whitelist.validator.CommandWhitelistPayload;
import com.xebialabs.deployit.plugin.cmd.whitelist.validator.CommandWhitelistValidator;
import java.io.IOException;
import java.io.Serializable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import scala.util.Left;
import scala.util.Right;

public class RemoteCommandWhitelistValidator
implements CommandWhitelistValidator {
    @Override
    public void validate(String user, String cmd) throws IOException {
        Serializable result = this.doRemoteQuery(user, cmd, SecurityContextHolder.getContext().getAuthentication());
        if (result == null) {
            throw new IllegalArgumentException("Cannot handle query response null");
        }
        this.processResult(result);
    }

    private void processResult(Serializable result) throws IOException {
        if (result instanceof Left) {
            Exception ex = (Exception)((Left)result).value();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
        } else if (!(result instanceof Right)) {
            throw new IllegalArgumentException("Cannot handle query response [" + result + "]");
        }
    }

    protected Serializable doRemoteQuery(String user, String cmd, Authentication authentication) {
        return RemoteServerQueryHandler.query((QueryExecutorHandler.QueryPayload)new CommandWhitelistPayload(user, cmd, authentication), (boolean)true);
    }
}

