package com.xebialabs.deployit.plugin.freemarker

import com.xebialabs.deployit.plugin.api.reflect.{PropertyDescriptor, PropertyKind}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import freemarker.ext.beans.BeanModel
import freemarker.template.TemplateModel
import scala.jdk.CollectionConverters._

class CiTemplateModel(ci: ConfigurationItem, wrapper: BaseCiAwareObjectWrapper) extends BeanModel(ci, wrapper) {
  private val MASKED_PASSWORD: String = "********"

  override def get(key: String): TemplateModel = {
    val pd = ci.getType.getDescriptor.getPropertyDescriptor(key)
    if (pd != null) {
      wrapper.wrap(extractValueFromCi(pd))
    } else {
      super.get(key)
    }
  }

  private def extractValueFromCi(pd: PropertyDescriptor): AnyRef = {
    if (pd.isPassword && wrapper.maskPasswords) {
      pd.getKind match {
        case PropertyKind.SET_OF_STRING => Set(MASKED_PASSWORD).asJava
        case PropertyKind.LIST_OF_STRING => Seq(MASKED_PASSWORD).asJava
        case PropertyKind.MAP_STRING_STRING => Map(MASKED_PASSWORD -> MASKED_PASSWORD).asJava
        case _ => MASKED_PASSWORD
      }
    } else pd.get(ci)
  }

  override def isEmpty: Boolean = false
}
