package com.xebialabs.deployit.plugin.freemarker.sanitizer

import com.xebialabs.overthere.util.WindowsCommandLineArgsSanitizer
import freemarker.template.TemplateMethodModelEx

class WindowsScriptSanitizer extends TemplateMethodModelEx {

  @SuppressWarnings(Array("ComparingUnrelatedTypes"))
  def exec(arguments: java.util.List[_]): String = {
    if (arguments == null || arguments.size() != 1 || arguments.get(0) == null)
      throw new IllegalArgumentException("Invalid arguments provided for sanitize expression")

    val value: String = arguments.get(0).toString
    if (value == null || value.isEmpty || value.equals("********"))
      return value
    return quote(WindowsCommandLineArgsSanitizer.sanitize(value))
  }
  private def quote(s: String) = s"""\"$s\""""

}
