package com.xebialabs.deployit.plugin

import java.util
import scala.jdk.CollectionConverters._

package object freemarker {
  private[freemarker] def any2Iterable(anyRef: AnyRef) = {
    anyRef.asInstanceOf[util.Collection[String]].asScala
  }

  private[freemarker] def any2Map(anyRef: AnyRef) = {
    anyRef.asInstanceOf[util.Map[String, String]].asScala.toMap
  }


  private[freemarker] def convertToJavaMap(context: AnyRef) = context match {
    case map: Map[_, _] => new util.HashMap[String, Any](map.asInstanceOf[Map[String, _]].asJava)
    case _ => context
  }
}
