package com.xebialabs.deployit.plugin.context

import com.xebialabs.deployit.plugin.api.creator.CreatorContext
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import grizzled.slf4j.Logger

import java.io.{PrintWriter, StringWriter}

class JythonCreatorContext(creatorContext: CreatorContext) extends CreatorContext {

  val ERROR_PREFIX = "[ERROR]: "
  val logger: Logger = Logger.apply(getClass)

  def logOutput(output: String): Unit = logOutputRaw(output + "\n")

  def logOutputRaw(output: String): Unit = {
    logger.debug(output.stripSuffix("\n"))
  }

  def logError(error: String): Unit = {
    logErrorRaw(error + "\n")
  }

  def logErrorRaw(error: String): Unit = {
    logErrorRaw(error, None)
  }

  def logError(error: String, t: Throwable): Unit = {
    logErrorRaw(error + "\n", Option(t))
  }

  private def logErrorRaw(error: String, t: Option[Throwable]): Unit = {
    t match {
      case Some(thr) => logger.error(error.stripSuffix("\n"), thr)
      case None => logger.error(error.stripSuffix("\n"))
    }
    t.foreach(logException)
  }

  private def logException(t: Throwable): Unit = {
    val stringWriter: StringWriter = new StringWriter
    t.printStackTrace(new PrintWriter(stringWriter))
  }

  override def getThisCI: ConfigurationItem = creatorContext.getThisCI

  override def create(item: ConfigurationItem): Unit = creatorContext.create(item)

}
