package com.xebialabs.deployit.plugin.freemarker

import com.xebialabs.deployit.plugin.steps.ArtifactKey
import com.xebialabs.overthere.OverthereFile
import freemarker.ext.beans.BeansWrapper
import freemarker.template.Configuration
import grizzled.slf4j.Logging


object ConfigurationHolder extends Logging {
  def configuration(maskPasswords: Boolean = false, artifactFiles: Map[ArtifactKey, OverthereFile] = Map.empty): Configuration = {
    configuration(new BaseCiAwareObjectWrapper(maskPasswords, artifactFiles))
  }

  def configuration(wrapper: BeansWrapper): Configuration = {
    val conf = new Configuration(Configuration.VERSION_2_3_31)
    conf.setNumberFormat("computer")
    conf.setTemplateLoader(new ClasspathTemplateLoader())
    conf.setObjectWrapper(wrapper)
    conf
  }
}
