package com.xebialabs.deployit.plugin.freemarker

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact
import com.xebialabs.deployit.plugin.steps.ArtifactKey
import com.xebialabs.overthere.OverthereFile
import freemarker.template.{Configuration, DefaultObjectWrapper, TemplateModel}


class BaseCiAwareObjectWrapper(private[freemarker] val maskPasswords: Boolean, private[freemarker] val artifactFiles: Map[ArtifactKey, OverthereFile]) extends DefaultObjectWrapper(Configuration.VERSION_2_3_31) {

  override def wrap(obj: scala.Any): TemplateModel = obj match {
    case artifact: Artifact =>
      val file = artifactFiles.get(ArtifactKey(artifact)).orNull
      new ArtifactModel(artifact, file, this)
    case ci: ConfigurationItem => new CiTemplateModel(ci, this)
    case other@_ => super.wrap(other)
  }
}
