package ai.digital.deploy.permissions.client.local.logging

import ai.digital.deploy.permissions.api.rest.dto.RoleWithPrincipalsDto
import ai.digital.deploy.permissions.client.util.SortOrder
import ai.digital.deploy.permissions.client.{PaginatedResponse, RolePrincipalsServiceClient}
import ai.digital.deploy.permissions.config.profile.PermissionServiceProfileConfig.EmbeddedPermissionServiceProfile
import grizzled.slf4j.Logging
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Service

@ConditionalOnProperty(name = Array("xl.permission-service.enabled"), havingValue = "false")
@Service
@Profile(Array(EmbeddedPermissionServiceProfile))
class LoggingRolePrincipalsServiceClient extends RolePrincipalsServiceClient with Logging {
  override def addPrincipals(roleName: String, principals: List[String]): RoleWithPrincipalsDto = {
    debug("Called addPrincipals - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def removePrincipals(roleName: String, principals: List[String]): RoleWithPrincipalsDto = {
    debug("Called removePrincipals - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def readPrincipals(roleName: String): List[String] = {
    debug("Called readPrincipals - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def read(rolePattern: String,
                    page: Int,
                    size: Int,
                    order: SortOrder,
                    field: String
  ): PaginatedResponse[RoleWithPrincipalsDto] = {
    debug("Called paginated read - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def read(principal: String,
                    rolePattern: String,
                    page: Int,
                    size: Int,
                    order: SortOrder,
                    field: String
  ): PaginatedResponse[RoleWithPrincipalsDto] = {
    debug("Called paginated read for principal - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def read(principals: List[String],
                    rolePattern: String,
                    page: Int,
                    size: Int,
                    order: SortOrder,
                    field: String
  ): PaginatedResponse[RoleWithPrincipalsDto] = {
    debug("Called paginated read for principals - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def readByRolePattern(rolePattern: String): List[RoleWithPrincipalsDto] = {
    debug("Called readByRolePattern - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def read(principal: String, rolePattern: String): List[RoleWithPrincipalsDto] = {
    debug("Called read - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def read(principals: List[String], rolePattern: String): List[RoleWithPrincipalsDto] = {
    debug("Called read for principals - void implementation")
    throw PermissionServiceNotImplementedException()
  }
}
