package ai.digital.deploy.permissions.client.configuration

import com.xebialabs.deployit.util.{DeployitKeys, PasswordEncrypter}
import com.xebialabs.deployit.{ServerConfigFile, ServerConfiguration}

import java.io.File

object ServerConfigurationHelper {

  val DEFAULT_CONFIGURATION_FILE = new File("conf", "deployit.conf")

  def init(): ServerConfiguration = {
    val passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey(null)
    PasswordEncrypter.init(passwordEncryptionKey)
    val config = new ServerConfigFile(DEFAULT_CONFIGURATION_FILE).loadConfig(false, false, true)
    ServerConfiguration.setInstance(config)
    config
  }

  def getKeyStorePassword: Option[String] =
    Option(ServerConfiguration.getInstance().getKeyStorePassword)
      .map(PasswordEncrypter.getInstance().ensureDecrypted)
}
