/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.client.local;

import ai.digital.deploy.permissions.api.rest.dto.ReferencedPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithGlobalPermissionsConverter$;
import ai.digital.deploy.permissions.client.PaginatedResponse;
import ai.digital.deploy.permissions.client.PermissionServiceClient;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.service.GlobalPermissionService;
import ai.digital.deploy.permissions.service.ReferencedPermissionService;
import ai.digital.deploy.permissions.service.RoleService;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ConditionalOnProperty(name={"xl.permission-service.enabled"}, havingValue="true", matchIfMissing=true)
@Service
@Profile(value={"permission-service"})
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001\u0002\t\u0012\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"AA\t\u0001B\u0001B\u0003%Q\tC\u0003J\u0001\u0011\u0005!\nC\u0003T\u0001\u0011\u0005C\u000b\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAq!a\u0003\u0001\t\u0003\ny\u0002C\u0004\u0002\f\u0001!\t%a\u000b\t\u000f\u0005-\u0001\u0001\"\u0011\u0002>!9\u0011q\t\u0001\u0005B\u0005%\u0003bBA8\u0001\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003\u000f\u0002A\u0011IAA\u0011\u001d\ty\u0007\u0001C!\u0003\u000b\u0013Q\u0004T8dC2\u0004VM]7jgNLwN\\:TKJ4\u0018nY3DY&,g\u000e\u001e\u0006\u0003%M\tQ\u0001\\8dC2T!\u0001F\u000b\u0002\r\rd\u0017.\u001a8u\u0015\t1r#A\u0006qKJl\u0017n]:j_:\u001c(B\u0001\r\u001a\u0003\u0019!W\r\u001d7ps*\u0011!dG\u0001\bI&<\u0017\u000e^1m\u0015\u0005a\u0012AA1j\u0007\u0001\u00192\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeJ\u0007\u0002'%\u0011\u0001f\u0005\u0002\u0018!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,7\t\\5f]R\fqc\u001a7pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005-rS\"\u0001\u0017\u000b\u00055*\u0012aB:feZL7-Z\u0005\u0003_1\u0012qc\u00127pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3)\u0005\u0005\t\u0004C\u0001\u001a>\u001b\u0005\u0019$B\u0001\u001b6\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003m]\nqAZ1di>\u0014\u0018P\u0003\u00029s\u0005)!-Z1og*\u0011!hO\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tA(A\u0002pe\u001eL!AP\u001a\u0003\u0013\u0005+Ho\\<je\u0016$\u0017a\u0007:fM\u0016\u0014XM\\2fIB+'/\\5tg&|gnU3sm&\u001cW\r\u0005\u0002,\u0003&\u0011!\t\f\u0002\u001c%\u00164WM]3oG\u0016$\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3)\u0005\t\t\u0014a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"a\u000b$\n\u0005\u001dc#a\u0003*pY\u0016\u001cVM\u001d<jG\u0016D#aA\u0019\u0002\rqJg.\u001b;?)\u0011YUjT)\u0011\u00051\u0003Q\"A\t\t\u000b%\"\u0001\u0019\u0001\u0016)\u00055\u000b\u0004\"B \u0005\u0001\u0004\u0001\u0005FA(2\u0011\u0015!E\u00011\u0001FQ\t\t\u0016'\u0001\bde\u0016\fG/Z(s+B$\u0017\r^3\u0015\u000bUCVM]?\u0011\u0005\u00012\u0016BA,\"\u0005\u0011)f.\u001b;\t\u000be+\u0001\u0019\u0001.\u0002!I,g-\u001a:f]\u000e,\u0017\nZ'bs\n,\u0007c\u0001\u0011\\;&\u0011A,\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017\u0001B;uS2T\u0011AY\u0001\u0005U\u00064\u0018-\u0003\u0002e?\n!Q+V%E\u0011\u00151W\u00011\u0001h\u0003!\u0011x\u000e\\3OC6,\u0007C\u00015p\u001d\tIW\u000e\u0005\u0002kC5\t1N\u0003\u0002m;\u00051AH]8pizJ!A\\\u0011\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003]\u0006BQa]\u0003A\u0002Q\f\u0001\u0003]3s[&\u001c8/[8ogR{\u0017\t\u001a3\u0011\u0007UTxM\u0004\u0002wq:\u0011!n^\u0005\u0002E%\u0011\u00110I\u0001\ba\u0006\u001c7.Y4f\u0013\tYHP\u0001\u0003MSN$(BA=\"\u0011\u0015qX\u00011\u0001u\u0003I\u0001XM]7jgNLwN\u001c+p\t\u0016dW\r^3\u0002%I,Wn\u001c<f\r>\u0014(+\u001a4fe\u0016t7-\u001a\u000b\u0004+\u0006\r\u0001BBA\u0003\r\u0001\u0007Q,A\u0006sK\u001a,'/\u001a8dK&#\u0017!\u0003:f[>4X-\u00117m)\u0005)\u0016aD2iK\u000e\\\u0007+\u001a:nSN\u001c\u0018n\u001c8\u0015\u0011\u0005=\u0011QCA\r\u00037\u00012\u0001IA\t\u0013\r\t\u0019\"\t\u0002\b\u0005>|G.Z1o\u0011\u0019\t9\u0002\u0003a\u00015\u0006q!/\u001a4fe\u0016t7-Z'bs\n,\u0007\"\u0002\f\t\u0001\u0004!\bBBA\u000f\u0011\u0001\u0007A/\u0001\u0005bY2\u0014v\u000e\\3t))\ty!!\t\u0002$\u0005\u0015\u0012q\u0005\u0005\u0007\u0003/I\u0001\u0019\u0001.\t\u000bYI\u0001\u0019\u0001;\t\r\u0005u\u0011\u00021\u0001u\u0011\u0019\tI#\u0003a\u0001i\u0006Q\u0001O]5oG&\u0004\u0018\r\\:\u0015\u0011\u00055\u00121GA\u001d\u0003w\u0001b\u0001[A\u0018O\u0006=\u0011bAA\u0019c\n\u0019Q*\u00199\t\u000f\u0005U\"\u00021\u0001\u00028\u0005Q!/\u001a4fe\u0016t7-Z:\u0011\u0007UTX\fC\u0003\u0017\u0015\u0001\u0007A\u000f\u0003\u0004\u0002\u001e)\u0001\r\u0001\u001e\u000b\u000b\u0003[\ty$!\u0011\u0002D\u0005\u0015\u0003bBA\u001b\u0017\u0001\u0007\u0011q\u0007\u0005\u0006--\u0001\r\u0001\u001e\u0005\u0007\u0003;Y\u0001\u0019\u0001;\t\r\u0005%2\u00021\u0001u\u0003a9W\r^!mYB+'/\\5tg&|gn\u001d$peJ{G.\u001a\u000b\t\u0003\u0017\ny&!\u0019\u0002lA!\u0011QJA.\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013a\u00013u_*!\u0011QKA,\u0003\u0011\u0011Xm\u001d;\u000b\u0007\u0005eS#A\u0002ba&LA!!\u0018\u0002P\t1\"k\u001c7f/&$\b\u000eU3s[&\u001c8/[8og\u0012#x\u000eC\u0003g\u0019\u0001\u0007q\rC\u0004\u0002d1\u0001\r!!\u001a\u0002\tA\fw-\u001a\t\u0004A\u0005\u001d\u0014bAA5C\t\u0019\u0011J\u001c;\t\u000f\u00055D\u00021\u0001\u0002f\u0005!1/\u001b>f\u0003e9W\r^!mYB+'/\\5tg&|gn\u001d$peJ{G.Z:\u0015\u0011\u0005M\u0014\u0011PA?\u0003\u007f\u0002RAJA;\u0003\u0017J1!a\u001e\u0014\u0005E\u0001\u0016mZ5oCR,GMU3ta>t7/\u001a\u0005\u0007\u0003wj\u0001\u0019\u0001;\u0002\u000b9\fW.Z:\t\u000f\u0005\rT\u00021\u0001\u0002f!9\u0011QN\u0007A\u0002\u0005\u0015D\u0003BA&\u0003\u0007CQA\u001a\bA\u0002\u001d$B!a\"\u0002\nB!QO_A&\u0011\u0019\tYi\u0004a\u0001i\u0006I!o\u001c7f\u001d\u0006lWm\u001d\u0015\u0004\u0001\u0005=\u0005\u0003BAI\u0003/k!!a%\u000b\u0007\u0005UU#A\u0002ka\u0006LA!!'\u0002\u0014\nqBK]1og\u0006\u001cG/[8oC2\u0004VM]7jgNLwN\\*feZL7-\u001a\u0015\b\u0001\u0005u\u00151VAW!\u0011\ty*a*\u000e\u0005\u0005\u0005&b\u0001\u001b\u0002$*\u0019\u0011QU\u001d\u0002\u000f\r|g\u000e^3yi&!\u0011\u0011VAQ\u0005\u001d\u0001&o\u001c4jY\u0016\fQA^1mk\u0016d#!a,\"\u0005\u0005E\u0016A\u00059fe6L7o]5p]6\u001aXM\u001d<jG\u0016D3\u0001AA[!\u0011\t9,!0\u000e\u0005\u0005e&bAA^s\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005}\u0016\u0011\u0018\u0002\b'\u0016\u0014h/[2fQ=\u0001\u00111YAl\u00033\fy.!9\u0002f\u0006\u001d\b\u0003BAc\u0003'l!!a2\u000b\t\u0005%\u00171Z\u0001\nG>tG-\u001b;j_:TA!!4\u0002P\u0006i\u0011-\u001e;pG>tg-[4ve\u0016T1!!5:\u0003\u0011\u0011wn\u001c;\n\t\u0005U\u0017q\u0019\u0002\u0016\u0007>tG-\u001b;j_:\fGn\u00148Qe>\u0004XM\u001d;z\u0003\u0011q\u0017-\\3-\u0005\u0005m\u0017EAAo\u0003uAHN\f9fe6L7o]5p]6\u001aXM\u001d<jG\u0016tSM\\1cY\u0016$\u0017a\u00035bm&twMV1mk\u0016\f#!a9\u0002\tQ\u0014X/Z\u0001\u000f[\u0006$8\r[%g\u001b&\u001c8/\u001b8h3\u0005\t\u0001")
public class LocalPermissionsServiceClient
implements PermissionServiceClient {
    @Autowired
    private final GlobalPermissionService globalPermissionService;
    @Autowired
    private final ReferencedPermissionService referencedPermissionService;
    @Autowired
    private final RoleService roleService;

    @Override
    public void createOrUpdate(Option<UUID> referenceIdMaybe, String roleName, List<String> permissionsToAdd, List<String> permissionToDelete) {
        Option<UUID> option = referenceIdMaybe;
        if (option instanceof Some) {
            Some some = (Some)option;
            UUID referenceId = (UUID)some.value();
            this.referencedPermissionService.edit(referenceId, roleName, permissionsToAdd, permissionToDelete);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.globalPermissionService.edit(roleName, permissionsToAdd, permissionToDelete);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void removeForReference(UUID referenceId) {
        this.referencedPermissionService.removeForReference(referenceId);
    }

    @Override
    public void removeAll() {
        this.referencedPermissionService.removeAll();
        this.globalPermissionService.removeAll();
    }

    @Override
    public boolean checkPermission(Option<UUID> referenceMaybe, List<String> permissions, List<String> allRoles) {
        return BoxesRunTime.unboxToBoolean((Object)referenceMaybe.map((Function1 & Serializable)referenceId -> BoxesRunTime.boxToBoolean((boolean)this.referencedPermissionService.checkPermission(referenceId, permissions, allRoles))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.globalPermissionService.checkPermission(permissions, allRoles)));
    }

    @Override
    public boolean checkPermission(Option<UUID> referenceMaybe, List<String> permissions, List<String> allRoles, List<String> principals) {
        return BoxesRunTime.unboxToBoolean((Object)referenceMaybe.map((Function1 & Serializable)referenceId -> BoxesRunTime.boxToBoolean((boolean)this.referencedPermissionService.checkPermission(referenceId, permissions, allRoles, principals))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.globalPermissionService.checkPermission(permissions, allRoles, principals)));
    }

    @Override
    public Map<String, Object> checkPermission(List<UUID> references, List<String> permissions, List<String> allRoles) {
        return references.isEmpty() ? (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"global"), (Object)BoxesRunTime.boxToBoolean((boolean)this.globalPermissionService.checkPermission(permissions, allRoles)))})) : references.map((Function1 & Serializable)reference -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reference.toString()), (Object)BoxesRunTime.boxToBoolean((boolean)$this.referencedPermissionService.checkPermission(reference, permissions, allRoles)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Map<String, Object> checkPermission(List<UUID> references, List<String> permissions, List<String> allRoles, List<String> principals) {
        return references.isEmpty() ? (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"global"), (Object)BoxesRunTime.boxToBoolean((boolean)this.globalPermissionService.checkPermission(permissions, allRoles, principals)))})) : references.map((Function1 & Serializable)reference -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reference.toString()), (Object)BoxesRunTime.boxToBoolean((boolean)$this.referencedPermissionService.checkPermission(reference, permissions, allRoles, principals)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public RoleWithPermissionsDto getAllPermissionsForRole(String roleName, int page, int size) {
        return this.getAllPermissionsForRole(roleName);
    }

    @Override
    public PaginatedResponse<RoleWithPermissionsDto> getAllPermissionsForRoles(List<String> names, int page, int size) {
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)size);
        Page roles = this.roleService.read(names, (Pageable)pageable);
        List roleNames = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)roles).asScala().toList().map((Function1 & Serializable)x$1 -> x$1.name());
        Map globalPermissions = this.globalPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$2 -> x$2.role().name());
        Map referencedPermissions = this.referencedPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$3 -> x$3.role().name());
        List dtos = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)roles).asScala().toList().map((Function1 & Serializable)role -> {
            Map referencedPermissionsForRole = ((IterableOps)referencedPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())).groupBy((Function1 & Serializable)x$4 -> x$4.reference());
            List referencedPermissionsDto = ((IterableOnceOps)referencedPermissionsForRole.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$5 -> x$5.permissionName())))).toList();
            return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto((List)globalPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), referencedPermissionsDto);
        });
        return new PaginatedResponse<RoleWithPermissionsDto>(dtos, roles.getTotalElements(), page, size, roles.hasNext());
    }

    @Override
    public RoleWithPermissionsDto getAllPermissionsForRole(String roleName) {
        List globalPermissions = this.globalPermissionService.read(roleName).map((Function1 & Serializable)x$6 -> x$6.permissionName());
        Map referencedPermissions = this.referencedPermissionService.read(roleName).groupBy((Function1 & Serializable)x$7 -> x$7.reference());
        Role role = (Role)this.roleService.read(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(roleName);
        });
        List referencedPermissionsDto = ((IterableOnceOps)referencedPermissions.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$8 -> x$8.permissionName())))).toList();
        return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), globalPermissions, referencedPermissionsDto);
    }

    @Override
    public List<RoleWithPermissionsDto> getAllPermissionsForRoles(List<String> roleNames) {
        Map globalPermissions = this.globalPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$9 -> x$9.role().name());
        Map referencedPermissions = this.referencedPermissionService.read(roleNames).groupBy((Function1 & Serializable)x$10 -> x$10.role().name());
        List roles = this.roleService.read(roleNames);
        return roles.map((Function1 & Serializable)role -> {
            Map referencedPermissionsForRole = ((IterableOps)referencedPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())).groupBy((Function1 & Serializable)x$11 -> x$11.reference());
            List referencedPermissionsDto = ((IterableOnceOps)referencedPermissionsForRole.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$12 -> x$12.permissionName())))).toList();
            return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto((List)globalPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), referencedPermissionsDto);
        });
    }

    public LocalPermissionsServiceClient(@Autowired GlobalPermissionService globalPermissionService, @Autowired ReferencedPermissionService referencedPermissionService, @Autowired RoleService roleService) {
        this.globalPermissionService = globalPermissionService;
        this.referencedPermissionService = referencedPermissionService;
        this.roleService = roleService;
    }
}

