package ai.digital.deploy.permissions.client.local.logging

import ai.digital.deploy.permissions.api.rest.dto.{RoleDto, RoleWithPrincipalsDto}
import ai.digital.deploy.permissions.client.util.SortOrder
import ai.digital.deploy.permissions.client.{PaginatedResponse, RoleServiceClient}
import ai.digital.deploy.permissions.config.profile.PermissionServiceProfileConfig.EmbeddedPermissionServiceProfile
import grizzled.slf4j.Logging
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Component

import java.util.UUID

@Component
@ConditionalOnProperty(name = Array("xl.permission-service.enabled"), havingValue = "false")
@Profile(Array(EmbeddedPermissionServiceProfile))
class LoggingRoleServiceClient extends RoleServiceClient with Logging {
  override def create(name: String, principals: List[String]): RoleWithPrincipalsDto = {
    debug("Called create with principals - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def createOrUpdate(role: RoleDto): RoleDto = {
    debug("Called createOrUpdate - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def update(originalRoleName: String,
                      updatedRoleName: String,
                      principalsToCreate: Set[String],
                      principalsToDelete: Set[String]
  ): RoleWithPrincipalsDto = {
    debug("Called update with principals - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def create(name: String): RoleDto = {
    debug("Called create - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def update(id: UUID, roleName: String): RoleDto = {
    debug("Called update - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def rename(name: String, newName: String): RoleDto = {
    debug("Called rename - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def delete(roleName: String): Unit = {
    debug("Called delete - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def deleteById(roleId: String): Unit = {
    debug("Called deleteById - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def readById(roleId: String): Option[RoleDto] = {
    debug("Called readById - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def read(roleName: String): Option[RoleDto] = {
    debug("Called read - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def read(namePattern: String, page: Int, size: Int, order: SortOrder, field: String): PaginatedResponse[RoleDto] = {
    debug("Called paginated read - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def getAll: List[RoleDto] = {
    debug("Called getAll - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def removeAllReferences(roleName: String): Unit = {
    debug("Called deleteAllReferences - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def removeAll(): Unit = {
    debug("Called removeAll - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def roleExists(roleName: String): Boolean = {
    debug("Called roleExists - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def countRoles(roleNamePattern: String): Long = {
    debug("Called countRoles - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def readByRolePattern(namePattern: String): List[RoleDto] = {
    debug("Called readByRolePattern - void implementation")
    throw PermissionServiceNotImplementedException()
  }
}
