package ai.digital.deploy.pendo.utils

import ai.digital.deploy.pendo.PendoConstants._
import ai.digital.deploy.pendo.deployment.state.events.PendoDeploymentTaskData
import ai.digital.deploy.pendo.utils.PendoUtils.PendoMap
import ai.digital.deploy.tasker.common.TaskMetadata
import com.xebialabs.analytics.pendo.PendoEvent

import java.time.Instant
import java.util.Date

object DeploymentExtractor {

  def deploymentCreatedData(task: PendoDeploymentTaskData): Option[PendoEvent] = {
    val properties = Map(
      DEPLOYMENT_ID -> task.id,
      TIMESTAMP -> new Date
    ).toPendo
    Some(PendoEvent(DEPLOYMENT_CREATED, properties, Instant.now.toEpochMilli))
  }

  def deploymentStartedData(task: PendoDeploymentTaskData): Option[PendoEvent] = {
    val properties = Map(
      DEPLOYMENT_ID -> task.id,
      TIMESTAMP -> new Date
    ).toPendo
    Some(PendoEvent(DEPLOYMENT_STARTED, properties, Instant.now.toEpochMilli))
  }

  def deploymentAbortedData(task: PendoDeploymentTaskData): Option[PendoEvent] = {
    val stepsProperties = PendoUtils.getStepsMetadata(task.stepsMetadata)
    val properties = stepsProperties ++ Map(
      APPLICATION_DEPENDENCY_PACKAGE_COUNT -> task.packageDependenciesCount,
      APPLICATION_ID -> task.metadata.getOrElse(TaskMetadata.VERSION_ID, ""),
      APPLICATION_NAME -> task.metadata.getOrElse(TaskMetadata.APPLICATION, ""),
      DEPLOYMENT_ID -> task.id,
      ENVIRONMENT -> task.metadata.getOrElse(TaskMetadata.ENVIRONMENT, ""),
      TIMESTAMP -> new Date
    ).toPendo
    Some(PendoEvent(DEPLOYMENT_ABORTED, properties, Instant.now.toEpochMilli))
  }

  def deploymentCancelledData(task: PendoDeploymentTaskData): Option[PendoEvent] = {
    val stepsProperties = PendoUtils.getStepsMetadata(task.stepsMetadata)
    val properties = stepsProperties ++ Map(
      APPLICATION_DEPENDENCY_PACKAGE_COUNT -> task.packageDependenciesCount,
      APPLICATION_ID -> task.metadata.getOrElse(TaskMetadata.VERSION_ID, ""),
      APPLICATION_NAME -> task.metadata.getOrElse(TaskMetadata.APPLICATION, ""),
      DEPLOYMENT_ID -> task.id,
      ENVIRONMENT -> task.metadata.getOrElse(TaskMetadata.ENVIRONMENT, ""),
      TIMESTAMP -> new Date
    ).toPendo
    Some(PendoEvent(DEPLOYMENT_CANCELLED, properties, Instant.now.toEpochMilli))
  }

  def deploymentFailedData(task: PendoDeploymentTaskData): Option[PendoEvent] = {
    val stepsProperties = PendoUtils.getStepsMetadata(task.stepsMetadata)
    val properties = stepsProperties ++ Map(
      APPLICATION_DEPENDENCY_PACKAGE_COUNT -> task.packageDependenciesCount,
      APPLICATION_ID -> task.metadata.getOrElse(TaskMetadata.VERSION_ID, ""),
      APPLICATION_NAME -> task.metadata.getOrElse(TaskMetadata.APPLICATION, ""),
      DEPLOYMENT_ID -> task.id,
      ENVIRONMENT -> task.metadata.getOrElse(TaskMetadata.ENVIRONMENT, ""),
      TIMESTAMP -> new Date
    ).toPendo
    Some(PendoEvent(DEPLOYMENT_FAILED, properties, Instant.now.toEpochMilli))
  }

  def deploymentExecutedData(task: PendoDeploymentTaskData): Option[PendoEvent] = {
    val stepsProperties = PendoUtils.getStepsMetadata(task.stepsMetadata)
    val properties = stepsProperties ++ Map(
      APPLICATION_DEPENDENCY_PACKAGE_COUNT -> task.packageDependenciesCount,
      APPLICATION_ID -> task.metadata.getOrElse(TaskMetadata.VERSION_ID, ""),
      APPLICATION_NAME -> task.metadata.getOrElse(TaskMetadata.APPLICATION, ""),
      DEPLOYMENT_ID -> task.id,
      ENVIRONMENT -> task.metadata.getOrElse(TaskMetadata.ENVIRONMENT, ""),
      TIMESTAMP -> new Date
    ).toPendo
    Some(PendoEvent(DEPLOYMENT_EXECUTED, properties, Instant.now.toEpochMilli))
  }
}
