package ai.digital.deploy.pendo.actor

import com.xebialabs.analytics.pendo.{PendoDataPublisher, PendoEventQueue, PendoSender}
import org.apache.pekko.actor.ActorRef

object PendoDataPublisherInitializer {

  var actor: ActorRef = _

  def setInstance(actorRef: ActorRef): Unit = actor = actorRef

  def getInstance(): ActorRef = actor
}

class PendoDataPublisherInitializer(queue: PendoEventQueue, sender: PendoSender) {

  lazy val pendoDataPublishingActor: ActorRef = PendoActorSystem.actorSystem.actorOf(PendoDataPublisher.props(queue, sender))

  PendoDataPublisherInitializer.setInstance(pendoDataPublishingActor)
}
