package ai.digital.deploy.pendo.utils

import ai.digital.deploy.pendo.utils.PendoUtils.generatePendoAccountId
import com.xebialabs.analytics.pendo.PendoAccountHolder
import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.core.service.PendoMetadataService
import com.xebialabs.license.LicenseProperty
import com.xebialabs.license.service.LicenseService
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.net.InetAddress

@Component
class DeployPendoAccountHolder extends PendoAccountHolder with Logging {

  @Autowired
  var serverConfiguration: ServerConfiguration = _

  @Autowired
  var licenseService: LicenseService = _

  @Autowired
  var pendoMetadataService: PendoMetadataService = _

  override def getVisitorId(): String = {
    val accountId = getAccountId()
    val host = InetAddress.getLocalHost.getHostName
    s"$accountId/$host"
  }

  override def getAccountId(): String = {
    var accountId: String = null
    val accountInfo = Map("serverUrl" -> serverConfiguration.getServerUrl, "name" -> licenseService.getLicense.getStringValue(LicenseProperty.LICENSED_TO))
    try {
      accountId = pendoMetadataService.getPendoAccountId()
    } catch {
      case e: Exception => logger.error("Exception occurred while fetching pendo account id", e)
    }
    if (accountId == null) {
      accountId = generatePendoAccountId(accountInfo)
      try {
        pendoMetadataService.savePendoAccountId(accountId)
      } catch {
        case e: Exception => logger.error("Exception occurred while saving pendo account id", e)
      }
    }
    accountId
  }
}
