package ai.digital.deploy.pendo

object PendoConstants {
    // Tracked events secret key
    val TRACKED_EVENT_INTEGRATION_KEY = "9701a1ad-9682-4f0c-62a8-83a8e3054e8e"

    // XLDeploy Deployment tracked events
    val TIMESTAMP: String = "timestamp"
    val DEPLOYMENT_ABORTED: String = "DeploymentAborted"
    val DEPLOYMENT_CANCELLED: String = "DeploymentCancelled"
    val DEPLOYMENT_CREATED: String = "DeploymentCreated"
    val DEPLOYMENT_EXECUTED: String = "DeploymentExecuted"
    val DEPLOYMENT_FAILED: String = "DeploymentFailed"
    val DEPLOYMENT_STARTED: String = "DeploymentStarted"

    // Deploy pendo properties
    val APPLICATION_DEPENDENCY_PACKAGE_COUNT: String = "appDependencyPackagesCount"
    val APPLICATION_ID: String = "applicationID"
    val APPLICATION_NAME: String = "applicationName"
    val DEPLOYMENT_ID: String = "deploymentId"
    val ENVIRONMENT: String = "environment"

    //XLDeploy License tracked events
    val LICENSE_METRICS: String = "LicenseMetrics"

    //XLDeploy CI Usage tracked events

    val TOTAL_APPLICATIONS = "totalApplications"
    val TOTAL_HOSTS ="totalHosts"
    val TOTAL_SATELLITES = "totalSatellites"
    val TOTAL_WORKERS = "totalWorkers"

    //XLDeploy Deployments Usage tracked events

    val TOTAL_DEPLOYMENTS_24_HRS = "totalDeploymentFor24hrs"
    val TOTAL_DEPLOYMENTS_30_DAYS = "totalDeploymentFor30days"
    val TOTAL_PENDING_DEPLOYMENTS = "totalPendingDeployments"
    val TOTAL_SCHEDULED_DEPLOYMENTS = "totalScheduledDeployments"
    val TOTAL_QUEUED_DEPLOYMENTS = "totalQueuedDeployments"
    val TOTAL_ACTIVE_DEPLOYMENTS = "totalActiveDeployments"

    //XLDeploy Control tasks Usage tracked events
    val TOTAL_TASKS_24_HRS = "totalTaskFor24hrs"
    val TOTAL_TASKS_30_DAYS = "totalTaskFor30days"
    val TOTAL_PENDING_TASKS = "totalPendingTasks"
    val TOTAL_SCHEDULED_TASKS = "totalScheduledTasks"
    val TOTAL_QUEUED_TASKS = "totalQueuedTasks"
    val TOTAL_ACTIVE_TASKS = "totalActiveTasks"

    //XLDeploy Users Usage tracked events
    val TOTAL_ACTIVE_USERS = "totalActiveUsers"

    //XLDeploy Folders Usage tracked events
    val TOTAL_APPLICATION_FOLDERS = "totalApplicationFolders"
    val TOTAL_ENVIRONMENT_FOLDERS = "totalEnvironmentFolders"
    val TOTAL_INFRASTRUCTURE_FOLDERS = "totalInfrastructureFolders"


    //XLDeploy Placeholders Usage tracked events
    val TOTAL_PLACEHOLDERS = "placeholdersCount"
    val USAGE_METRICS: String = "UsageMetrics"


    //XlDeploy Installation tracked events
    val DEPLOY_VERSION: String = "deployVersion"
    val MAX_MEMORY: String = "maxMemory"
    val MAIN_DB_TYPE: String = "mainDbType"
    val REPORTING_DB_TYPE: String = "archiveDbType"
    val CLUSTER_MODE: String = "clusterMode"
    val NUMBER_OF_NODES: String = "numberOfNodes"
    val INSTALLATION_METRICS: String = "InstallationMetrics"
    val VM_VERSION: String = "vmVersion"
    val OS_NAME: String = "osName"
    val USED_MEMORY: String = "usedMemory"

    //XLDeploy license tracked events
    val PRODUCT_NAME = "productName"
    val LICENSE_EXPIRATION_DATE = "licenseExpirationDate"
    val CUSTOMER_NAME = "customerName"
    val LICENSE_VERSION = "licenseVersion"
    val LICENSE_PLUGINS = "licensePlugins"
    val LICENSE_EDITION = "licenseEdition"
    val LICENSE_APPLICATION = "licenseApplication"
    val INSTANCE_APPLICATION = "instanceApplication"
    val APPLICATION_KEY = "Application"
    val LICENSE_HOST = "licenseHost"
    val INSTANCE_HOST = "instanceHost"
    val HOST_KEY = "Host"
    val LICENSE_SATELLITE = "licenseSatellite"
    val INSTANCE_SATELLITE = "instanceSatellite"
    val SATELLITE_KEY = "Satellite"
    val DEPLOY = "Deploy"


}
