package ai.digital.deploy.pendo

import ai.digital.configuration.central.deploy.ServerSideProperties
import ai.digital.deploy.pendo.actor.{PendoActorSystem, PendoDataPublisherInitializer}
import ai.digital.deploy.pendo.utils.PendoUtils.generatePendoIds
import com.xebialabs.analytics.pendo.{PendoEventQueue, PendoSender}
import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.license.LicenseProperty
import com.xebialabs.license.service.LicenseService
import grizzled.slf4j.Logging
import org.apache.pekko.actor.ActorSystem
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Bean, Configuration}

import java.net.InetAddress

@Configuration
class XldPendoConfiguration extends Logging {

  @Autowired
  var serverConfiguration: ServerConfiguration = _

  @Autowired
  var licenseService: LicenseService = _

  @Autowired
  var serverSideConfiguration: ServerSideProperties = _

  @Bean
  def pendoEventQueue(): PendoEventQueue = new PendoEventQueue(serverSideConfiguration.analytics.pendoQueueSize)

  @Bean
  def pendoSender(): PendoSender = {
    implicit val actorSystem: ActorSystem = PendoActorSystem.actorSystem
    val accountInfo = Map("serverUrl" -> serverConfiguration.getServerUrl, "name" -> licenseService.getLicense.getStringValue(LicenseProperty.LICENSED_TO))
    val host = InetAddress.getLocalHost.getHostName
    val (accountId, visitorId) = generatePendoIds(accountInfo, host)
    new PendoSender(accountId, visitorId, PendoConstants.TRACKED_EVENT_INTEGRATION_KEY)
  }

  @Bean
  def pendoDataPublisherInitializer(queue: PendoEventQueue, sender: PendoSender): PendoDataPublisherInitializer = {
    new PendoDataPublisherInitializer(queue, sender)
  }
}
