package ai.digital.deploy.pendo.utils

import ai.digital.deploy.pendo.PendoConstants._
import ai.digital.deploy.pendo.utils.PendoUtils.PendoMap
import ai.digital.deploy.tasker.common.TaskMetadata
import com.xebialabs.analytics.pendo.PendoEvent
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps

import java.time.Instant
import java.util.Date
import scala.jdk.CollectionConverters.ListHasAsScala

object DeploymentExtractor {

  def deploymentCreatedData(task: TaskWithSteps): Option[PendoEvent] = {
    val properties = Map(
      DEPLOYMENT_ID -> task.getId,
      TIMESTAMP -> new Date
    ).toPendo
    Some(PendoEvent(DEPLOYMENT_CREATED, properties, Instant.now.toEpochMilli))
  }

  def deploymentStartedData(task: TaskWithSteps): Option[PendoEvent] = {
    val properties = Map(
      DEPLOYMENT_ID -> task.getId,
      TIMESTAMP -> new Date
    ).toPendo
    Some(PendoEvent(DEPLOYMENT_STARTED, properties, Instant.now.toEpochMilli))
  }

  def deploymentAbortedData(task: TaskWithSteps): Option[PendoEvent] = {
    val stepsProperties = PendoUtils.getStepsMetadata(task.getSteps.asScala.toList)
    val properties = stepsProperties ++ Map(
      APPLICATION_DEPENDENCY_PACKAGE_COUNT -> task.getPackageDependencies.size(),
      APPLICATION_ID -> task.getMetadata.get(TaskMetadata.VERSION_ID),
      APPLICATION_NAME -> task.getMetadata.get(TaskMetadata.APPLICATION),
      DEPLOYMENT_ID -> task.getId,
      ENVIRONMENT -> task.getMetadata.get(TaskMetadata.ENVIRONMENT),
      TIMESTAMP -> new Date
    ).toPendo
    Some(PendoEvent(DEPLOYMENT_ABORTED, properties, Instant.now.toEpochMilli))
  }

  def deploymentCancelledData(task: TaskWithSteps): Option[PendoEvent] = {
    val stepsProperties = PendoUtils.getStepsMetadata(task.getSteps.asScala.toList)
    val properties = stepsProperties ++ Map(
      APPLICATION_DEPENDENCY_PACKAGE_COUNT -> task.getPackageDependencies.size(),
      APPLICATION_ID -> task.getMetadata.get(TaskMetadata.VERSION_ID),
      APPLICATION_NAME -> task.getMetadata.get(TaskMetadata.APPLICATION),
      DEPLOYMENT_ID -> task.getId,
      ENVIRONMENT -> task.getMetadata.get(TaskMetadata.ENVIRONMENT),
      TIMESTAMP -> new Date
    ).toPendo
    Some(PendoEvent(DEPLOYMENT_CANCELLED, properties, Instant.now.toEpochMilli))
  }

  def deploymentFailedData(task: TaskWithSteps): Option[PendoEvent] = {
    val stepsProperties = PendoUtils.getStepsMetadata(task.getSteps.asScala.toList)
    val properties = stepsProperties ++ Map(
      APPLICATION_DEPENDENCY_PACKAGE_COUNT -> task.getPackageDependencies.size(),
      APPLICATION_ID -> task.getMetadata.get(TaskMetadata.VERSION_ID),
      APPLICATION_NAME -> task.getMetadata.get(TaskMetadata.APPLICATION),
      DEPLOYMENT_ID -> task.getId,
      ENVIRONMENT -> task.getMetadata.get(TaskMetadata.ENVIRONMENT),
      TIMESTAMP -> new Date
    ).toPendo
    Some(PendoEvent(DEPLOYMENT_FAILED, properties, Instant.now.toEpochMilli))
  }

  def deploymentExecutedData(task: TaskWithSteps): Option[PendoEvent] = {
    val stepsProperties = PendoUtils.getStepsMetadata(task.getSteps.asScala.toList)
    val properties = stepsProperties ++ Map(
      APPLICATION_DEPENDENCY_PACKAGE_COUNT -> task.getPackageDependencies.size(),
      APPLICATION_ID -> task.getMetadata.get(TaskMetadata.VERSION_ID),
      APPLICATION_NAME -> task.getMetadata.get(TaskMetadata.APPLICATION),
      DEPLOYMENT_ID -> task.getId,
      ENVIRONMENT -> task.getMetadata.get(TaskMetadata.ENVIRONMENT),
      TIMESTAMP -> new Date
    ).toPendo
    Some(PendoEvent(DEPLOYMENT_EXECUTED, properties, Instant.now.toEpochMilli))
  }
}
