package ai.digital.deploy.pendo.actor

import akka.actor.{ActorSystem, Terminated}
import grizzled.slf4j.Logging

import javax.annotation.PreDestroy
import scala.concurrent.Await.result
import scala.concurrent.duration.DurationInt

object PendoActorSystem extends Logging {

  val actorSystem: ActorSystem = newActorSystem

  private def newActorSystem: ActorSystem = {
    logger.info("Starting the deploy-pendo actor system")
    ActorSystem.create("deploy-pendo-system")
  }

  @PreDestroy
  def shutdownTheSystem(): Terminated = {
    logger.info("Shutting down the deploy-pendo actor system...")
    result(actorSystem.terminate(), 20.seconds)
  }

}
