package ai.digital.deploy.pendo

import ai.digital.configuration.central.deploy.ServerSideProperties
import ai.digital.deploy.pendo.actor.{PendoActorSystem, PendoDataPublisherInitializer}
import com.xebialabs.analytics.pendo.{PendoAccountHolder, PendoEventQueue, PendoSender}
import grizzled.slf4j.Logging
import akka.actor.ActorSystem
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class XldPendoConfiguration extends Logging {

  @Autowired
  var serverSideConfiguration: ServerSideProperties = _

  @Bean
  def pendoEventQueue(): PendoEventQueue = new PendoEventQueue(serverSideConfiguration.analytics.pendoQueueSize)

  @Autowired
  var pendoAccountHolder: PendoAccountHolder = _

  @Bean
  def pendoSender(): PendoSender = {
    implicit val actorSystem: ActorSystem = PendoActorSystem.actorSystem
    new PendoSender(pendoAccountHolder, PendoConstants.TRACKED_EVENT_INTEGRATION_KEY)
  }

  @Bean
  def pendoDataPublisherInitializer(queue: PendoEventQueue, sender: PendoSender): PendoDataPublisherInitializer = {
    new PendoDataPublisherInitializer(queue, sender)
  }
}
