package ai.digital.deploy.notification

import ai.digital.deploy.notification.events.UserTokenAboutToExpireEvent
import com.xebialabs.deployit.engine.spi.event.SpringInstantiatedListener
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jms.core.JmsTemplate
import org.springframework.stereotype.Component
import com.xebialabs.xldeploy.jms.adapter.DeployNotificationQueueNameResolver


@Component
@Autowired
class XldNotificationProducer(@Qualifier("deployNotificationJmsTemplate") jmsTemplate: JmsTemplate,
                                   deployNotificationQueueNameResolver: DeployNotificationQueueNameResolver) extends SpringInstantiatedListener with XldNotificationStore with Logging {

  override def handlePatNotificationEvent(event: UserTokenAboutToExpireEvent): Unit = {
    jmsTemplate.convertAndSend(deployNotificationQueueNameResolver.getDeployNotificationQueueName, event)
  }
}

trait XldNotificationStore {
  def handlePatNotificationEvent(event: UserTokenAboutToExpireEvent): Unit
}

