/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.notification.service;

import ai.digital.deploy.notification.email.MultipartEmailSender;
import ai.digital.deploy.notification.events.UserTokenAboutToExpireEvent;
import ai.digital.deploy.sql.model.ConfigurationDto;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.mail.SmtpServer;
import com.xebialabs.deployit.repository.ConfigurationRepository;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.service.UserProfileService;
import com.xebialabs.deployit.security.service.UserTokenService;
import com.xebialabs.deployit.service.dependency.RepositoryServiceAware;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001B\b\u0011\u0001mA\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!\t\u0006A!b\u0001\n\u0003\u0012\u0006\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u000b]\u0003A\u0011\u0001-\t\u0011=\u0004\u0001R1A\u0005\nADQ\u0001 \u0001\u0005\u0002uDq!a\u0005\u0001\t\u0013\t)\u0002C\u0004\u0002:\u0001!I!a\u000f\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D!9\u0011Q\u000b\u0001\u0005\n\u0005]\u0003bBA0\u0001\u0011%\u0011\u0011\r\u0002\u001c!\u0006#V)\\1jY:{G/\u001b4jG\u0006$\u0018n\u001c8TKJ4\u0018nY3\u000b\u0005E\u0011\u0012aB:feZL7-\u001a\u0006\u0003'Q\tAB\\8uS\u001aL7-\u0019;j_:T!!\u0006\f\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0002$A\u0004eS\u001eLG/\u00197\u000b\u0003e\t!!Y5\u0004\u0001M!\u0001\u0001\b\u0012+!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0006g24GG\u001b\u0006\u0002O\u0005AqM]5{u2,G-\u0003\u0002*I\t9Aj\\4hS:<\u0007CA\u00166\u001b\u0005a#BA\u0017/\u0003)!W\r]3oI\u0016t7-\u001f\u0006\u0003#=R!\u0001M\u0019\u0002\u0011\u0011,\u0007\u000f\\8zSRT!AM\u001a\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u001b\u0002\u0007\r|W.\u0003\u00027Y\t1\"+\u001a9pg&$xN]=TKJ4\u0018nY3Bo\u0006\u0014X-\u0001\nvg\u0016\u0014\bK]8gS2,7+\u001a:wS\u000e,\u0007CA\u001d>\u001b\u0005Q$BA\t<\u0015\tat&\u0001\u0005tK\u000e,(/\u001b;z\u0013\tq$H\u0001\nVg\u0016\u0014\bK]8gS2,7+\u001a:wS\u000e,\u0017\u0001E;tKJ$vn[3o'\u0016\u0014h/[2f!\tI\u0014)\u0003\u0002Cu\t\u0001Rk]3s)>\\WM\\*feZL7-Z\u0001\u0015[VdG/\u001b9beR,U.Y5m'\u0016tG-\u001a:\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d\u0013\u0012!B3nC&d\u0017BA%G\u0005QiU\u000f\u001c;ja\u0006\u0014H/R7bS2\u001cVM\u001c3fe\u000692m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d>\n!B]3q_NLGo\u001c:z\u0013\t\u0001VJA\fD_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006\t\"/\u001a9pg&$xN]=TKJ4\u0018nY3\u0016\u0003M\u0003\"\u0001\u0014+\n\u0005Uk%!\u0005*fa>\u001c\u0018\u000e^8ssN+'O^5dK\u0006\u0011\"/\u001a9pg&$xN]=TKJ4\u0018nY3!\u0003\u0019a\u0014N\\5u}Q1\u0011l\u0017/^=~\u0003\"A\u0017\u0001\u000e\u0003AAQaN\u0004A\u0002aBQaP\u0004A\u0002\u0001CQaQ\u0004A\u0002\u0011CQAS\u0004A\u0002-CQ!U\u0004A\u0002MC#aB1\u0011\u0005\tlW\"A2\u000b\u0005\u0011,\u0017AC1o]>$\u0018\r^5p]*\u0011amZ\u0001\bM\u0006\u001cGo\u001c:z\u0015\tA\u0017.A\u0003cK\u0006t7O\u0003\u0002kW\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001m\u0003\ry'oZ\u0005\u0003]\u000e\u0014\u0011\"Q;u_^L'/\u001a3\u0002\u0013M,'O^3s+JdW#A9\u0011\u0005ILhBA:x!\t!h$D\u0001v\u0015\t1($\u0001\u0004=e>|GOP\u0005\u0003qz\ta\u0001\u0015:fI\u00164\u0017B\u0001>|\u0005\u0019\u0019FO]5oO*\u0011\u0001PH\u0001\u0011g\u0016tGMT8uS\u001aL7-\u0019;j_:$2A`A\u0002!\tir0C\u0002\u0002\u0002y\u0011A!\u00168ji\"9\u0011QA\u0005A\u0002\u0005\u001d\u0011!B3wK:$\b\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055!#\u0001\u0004fm\u0016tGo]\u0005\u0005\u0003#\tYAA\u000eVg\u0016\u0014Hk\\6f]\u0006\u0013w.\u001e;U_\u0016C\b/\u001b:f\u000bZ,g\u000e^\u0001\u0010g\u0016tG-\u0012=qSJLX)\\1jYRIa0a\u0006\u0002,\u00055\u0012q\u0006\u0005\b\u00033Q\u0001\u0019AA\u000e\u0003)i\u0017-\u001b7TKJ4XM\u001d\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0011i\u0017-\u001b7\u000b\u0007\u0005\u0015r&\u0001\u0004qYV<\u0017N\\\u0005\u0005\u0003S\tyB\u0001\u0006T[R\u00048+\u001a:wKJDQa\u0012\u0006A\u0002EDq!!\u0002\u000b\u0001\u0004\t9\u0001C\u0004\u00022)\u0001\r!a\r\u0002\u00171|wm\u001c$jY\u0016|\u0005\u000f\u001e\t\u0005;\u0005U\u0012/C\u0002\u00028y\u0011aa\u00149uS>t\u0017\u0001D4fiV\u001bXM]#nC&dG\u0003BA\u001a\u0003{Aa!a\u0010\f\u0001\u0004\t\u0018\u0001C;tKJt\u0017-\\3\u0002\u001b\u001d,G/T1jYN+'O^3s)\u0019\t)%a\u0012\u0002LA)Q$!\u000e\u0002\u001c!1\u0011\u0011\n\u0007A\u0002E\faa]7ua&#\u0007bBA'\u0019\u0001\u0007\u0011qJ\u0001\bi>\\WM\\%e!\ri\u0012\u0011K\u0005\u0004\u0003'r\"aA%oi\u0006\u0011r-\u001a;HK:,'/\u00197TKR$\u0018N\\4t)\t\tI\u0006E\u0003s\u00037\n\u0018/C\u0002\u0002^m\u00141!T1q\u0003A1wN]7bi\u0016C\b/\u001b:z\t\u0006$X\rF\u0002r\u0003GBq!!\u001a\u000f\u0001\u0004\t9'\u0001\u0006fqBL'/\u001f#bi\u0016\u0004B!!\u001b\u0002t5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'\u0001\u0003vi&d'BAA9\u0003\u0011Q\u0017M^1\n\t\u0005U\u00141\u000e\u0002\u0005\t\u0006$X\rK\u0002\u0001\u0003s\u0002B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007fJ\u0017AC:uKJ,w\u000e^=qK&!\u00111QA?\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class PATEmailNotificationService
implements Logging,
RepositoryServiceAware {
    private String serverUrl;
    private final UserProfileService userProfileService;
    private final UserTokenService userTokenService;
    private final MultipartEmailSender multipartEmailSender;
    private final ConfigurationRepository configurationRepository;
    private final RepositoryService repositoryService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public <CI extends ConfigurationItem> SearchParameters typedSearchParameters(ClassTag<CI> evidence$1) {
        return RepositoryServiceAware.typedSearchParameters$((RepositoryServiceAware)this, evidence$1);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PATEmailNotificationService pATEmailNotificationService = this;
        synchronized (pATEmailNotificationService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    private String serverUrl$lzycompute() {
        PATEmailNotificationService pATEmailNotificationService = this;
        synchronized (pATEmailNotificationService) {
            if (!this.bitmap$0) {
                this.serverUrl = ServerConfiguration.getInstance().getServerUrl();
                this.bitmap$0 = true;
            }
        }
        return this.serverUrl;
    }

    private String serverUrl() {
        if (!this.bitmap$0) {
            return this.serverUrl$lzycompute();
        }
        return this.serverUrl;
    }

    public void sendNotification(UserTokenAboutToExpireEvent event) {
        this.logger().info((Function0 & Serializable)() -> "Sending email notification for expiring PAT token for user: " + event.username());
        Map<String, String> settings = this.getGeneralSettings();
        Option mailServerRefOpt = settings.get((Object)"pat_email_notification_smtp_server_ci_ref");
        Option logoFileOpt = settings.get((Object)"logo_file");
        if (mailServerRefOpt.isEmpty()) {
            this.logger().info((Function0 & Serializable)() -> "PAT Notification: Email server is not set properly in general settings. Hence skipping PAT notification.");
            return;
        }
        Option mailServerOpt = mailServerRefOpt.flatMap((Function1 & Serializable)x$1 -> this.getMailServer((String)x$1, Predef$.MODULE$.Integer2int(event.userToken().getCiId())));
        Option<String> emailOpt = this.getUserEmail(event.username());
        mailServerOpt.foreach((Function1 & Serializable)mailServer -> {
            emailOpt.foreach((Function1 & Serializable)email -> {
                $this.sendExpiryEmail(mailServer, email, event$1, (Option<String>)logoFileOpt$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    private void sendExpiryEmail(SmtpServer mailServer, String email, UserTokenAboutToExpireEvent event, Option<String> logoFileOpt) {
        Date expiryDate = event.userToken().getExpiryDate();
        boolean hasCustomLogo = logoFileOpt.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2))));
        Option customLogoParam = logoFileOpt.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$3)))).map((Function1 & Serializable)logo -> new Tuple2((Object)"customLogo", logo));
        this.multipartEmailSender.sendCustomEmail(mailServer, mailServer.getFromAddress(), (List<String>)new .colon.colon((Object)email, (List)Nil$.MODULE$), "[Deploy] Your personal access token is about to expire", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tokenNote"), (Object)event.userToken().getTokenNote()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tokenExpiryDate"), (Object)this.formatExpiryDate(expiryDate)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"accessTokensUrl"), (Object)(this.serverUrl() + "#/personalsettings/tokens")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)this.serverUrl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isCustomLogoSettingsDefined"), (Object)BoxesRunTime.boxToBoolean((boolean)hasCustomLogo))}))), (Option<String>)new Some((Object)"templates/email_base_template.ftl"), (Option<String>)new Some((Object)"email_content_access_token.ftl"), (Option<String>)None$.MODULE$, (Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deploy-logo-white"), (Object)"images/deploy-logo.png"), (List)Nil$.MODULE$), (Option<Tuple2<String, String>>)customLogoParam);
    }

    private Option<String> getUserEmail(String username) {
        None$ none$;
        block3: {
            try {
                Some some;
                String email;
                Option userEmailOpt;
                Option option = userEmailOpt = Option$.MODULE$.apply((Object)this.userProfileService.findOne(username)).flatMap((Function1 & Serializable)profile -> Option$.MODULE$.apply((Object)profile.email()));
                if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((email = (String)(some = (Some)option).value()).trim()))) {
                    none$ = new Some((Object)email);
                    break block3;
                }
                this.logger().info((Function0 & Serializable)() -> "User email not configured. Hence skipping PAT notification.");
                none$ = None$.MODULE$;
            }
            catch (NotFoundException notFoundException) {
                this.logger().info((Function0 & Serializable)() -> "No user profile found for user: " + username + ". Hence skipping PAT notification.");
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private Option<SmtpServer> getMailServer(String smtpId, int tokenId) {
        None$ none$;
        try {
            none$ = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.repositoryService().listEntities(this.typedSearchParameters(ClassTag$.MODULE$.apply(SmtpServer.class)))).asScala().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PATEmailNotificationService.$anonfun$getMailServer$1(smtpId, x$4))).orElse((Function0 & Serializable)() -> {
                this.logger().info((Function0 & Serializable)() -> "SMTP server with ID: " + smtpId + " not found. Hence skipping PAT notification.");
                return None$.MODULE$;
            });
        }
        catch (NotFoundException notFoundException) {
            this.logger().info((Function0 & Serializable)() -> "SMTP server with ID: " + smtpId + " not found. Hence skipping PAT notification.");
            this.userTokenService.updateTokenExpiredNotified(tokenId, (Date)Timestamp.from(Instant.now()), false);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Map<String, String> getGeneralSettings() {
        return this.configurationRepository.getConfigurationByKey().filter((Function1 & Serializable)conf -> BoxesRunTime.boxToBoolean((boolean)PATEmailNotificationService.$anonfun$getGeneralSettings$1(conf))).map((Function1 & Serializable)conf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])conf.key().split("\\.")))), (Object)conf.value())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private String formatExpiryDate(Date expiryDate) {
        LocalDate expiry;
        LocalDate today = LocalDate.now(ZoneId.of("UTC"));
        long daysBetween = ChronoUnit.DAYS.between(today, expiry = expiryDate.toInstant().atZone(ZoneId.of("UTC")).toLocalDate());
        if (daysBetween <= 0L) {
            return "today";
        }
        return "in " + daysBetween + " day(s)";
    }

    public static final /* synthetic */ boolean $anonfun$getMailServer$1(String smtpId$1, SmtpServer x$4) {
        return BoxesRunTime.equalsNumObject((Number)x$4.get$internalId(), (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(smtpId$1))));
    }

    public static final /* synthetic */ boolean $anonfun$getGeneralSettings$1(ConfigurationDto conf) {
        return conf.key().endsWith("logo_file") || conf.key().endsWith("pat_email_notification_smtp_server_ci_ref");
    }

    @Autowired
    public PATEmailNotificationService(UserProfileService userProfileService, UserTokenService userTokenService, MultipartEmailSender multipartEmailSender, ConfigurationRepository configurationRepository, RepositoryService repositoryService) {
        this.userProfileService = userProfileService;
        this.userTokenService = userTokenService;
        this.multipartEmailSender = multipartEmailSender;
        this.configurationRepository = configurationRepository;
        this.repositoryService = repositoryService;
        Logging.$init$((Logging)this);
        RepositoryServiceAware.$init$((RepositoryServiceAware)this);
    }
}

