package com.xebialabs.xldeploy.jms.broker

import ai.digital.configuration.central.deploy.InProcessConfig
import org.apache.activemq.artemis.api.core.TransportConfiguration
import org.apache.activemq.artemis.core.config.Configuration
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory

object EmbeddedBrokerConfig {
  val address: String = "vm://0"
  private val queueName: String = "xld-embedded-broker"

  def brokerConfiguration(xldConfig: InProcessConfig): Configuration = {
    val config = new ConfigurationImpl()
    config.addAcceptorConfiguration(new TransportConfiguration(classOf[InVMAcceptorFactory].getName))
    config.setSecurityEnabled(false)
    config.setClusterUser(xldConfig.userName)
    config.setClusterPassword(xldConfig.password)
    config.setGracefulShutdownEnabled(false)
    config.setGracefulShutdownTimeout(xldConfig.shutdownTimeout) // in ms
    config.setMaxDiskUsage(xldConfig.maxDiskUsage) // percent
    config.setName(queueName)
    config
  }
}
