package com.xebialabs.xldeploy.jms.broker

import ai.digital.configuration.central.deploy.InProcessConfig
import grizzled.slf4j.Logging
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ

class EmbeddedBroker(inProcessConfig: InProcessConfig) extends Logging {

  private var embeddedServer: EmbeddedActiveMQ = _

  def start(): Unit = synchronized {
    logger.info("Starting ActiveMQ Artemis embedded broker.")
    embeddedServer = new EmbeddedActiveMQ()
    embeddedServer.setConfiguration(EmbeddedBrokerConfig.brokerConfiguration(inProcessConfig))

    embeddedServer.start()
    logger.info("ActiveMQ Artemis embedded broker started.")
  }

  def shutdown(): Unit = {
    if (embeddedServer != null) {
      logger.info("Shutting down ActiveMQ Artemis embedded broker.")
      embeddedServer.stop()
      logger.info("ActiveMQ Artemis embedded broker stopped.")
    }
  }

}
