package com.xebialabs.xldeploy.jms.validator

import com.xebialabs.xldeploy.jms.adapter.UnsupportedJmsConfigurationException
import org.springframework.beans.factory.annotation.Value
import org.springframework.stereotype.Component

import jakarta.annotation.PostConstruct

@Component
class JmsConfigValidator {

  @Value("${deploy.task.in-process-worker:true}") var inProcessTaskEngine: Boolean = _

  @Value("${deploy.task.queue.external.jms-driver-classname:@null}") var jmsDriverClassname: String = _

  @Value("${deploy.task.queue.external.jms-username:@null}") var jmsUsername: String = _

  @Value("${deploy.task.queue.external.jms-password:@null}") var jmsPassword: String = _

  @PostConstruct def validate(): Unit = {
    if (!inProcessTaskEngine && !hasExternalQueueConfig) {
      throw UnsupportedJmsConfigurationException(
        "Unsupported configuration: when deploy.task.in-process-worker is set to 'false' external broker should be configured correctly" +
          " (check deploy.task.queue.external path for errors)."
      )
    }
  }

  private def hasExternalQueueConfig: Boolean = {
      jmsDriverClassname != null &&
      jmsDriverClassname != null &&
      jmsUsername != null &&
      jmsPassword != null
  }
}
