package com.xebialabs.xldeploy.jms.factory

import ai.digital.configuration.central.deploy.TaskQueueBrokerConfig
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Value}

import javax.jms.ConnectionFactory

abstract class BaseJmsConnectionFactory extends JmsConnectionFactory with Logging {

  @Autowired
  var taskQueueBrokerConfig: TaskQueueBrokerConfig = _

  @Value("${deploy.task.in-process-worker:true}")
  var inProcessTaskEngine: Boolean = _

  override def create(): ConnectionFactory = {
    factory()
  }

  protected def factory(): ConnectionFactory
}
