package com.xebialabs.xldeploy.jms.factory

import com.xebialabs.xldeploy.jms.broker.EmbeddedBrokerConfig
import jakarta.jms.ConnectionFactory
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory
import ai.digital.configuration.central.deploy.TaskerSystemProperties

object EmbeddedBrokerConnectionFactory {
  def initialize(): ConnectionFactory = {
    val cf = new ActiveMQConnectionFactory(EmbeddedBrokerConfig.address)
    val taskerSystemProperties = new TaskerSystemProperties
    cf.setUser(taskerSystemProperties.queue.inProcess.userName)
    cf.setPassword(taskerSystemProperties.queue.inProcess.password)
    cf
  }
}
