package com.xebialabs.xldeploy.jms.factory

import com.xebialabs.xldeploy.jms.broker.EmbeddedBrokerConfig
import javax.jms.ConnectionFactory
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory

object EmbeddedBrokerConnectionFactory {
  def initialize(): ConnectionFactory = {
    val cf = new ActiveMQConnectionFactory(EmbeddedBrokerConfig.address)
    cf.setUser(EmbeddedBrokerConfig.username).setPassword(EmbeddedBrokerConfig.password)
    cf
  }
}
