package com.xebialabs.xldeploy.jms.factory

import ai.digital.configuration.central.deploy.ExternalConfig
import com.xebialabs.xldeploy.jms.adapter.UnsupportedJmsConfigurationException
import com.xebialabs.xldeploy.jms.config.ArtemisConfig
import org.apache.activemq.artemis.api.core.{DiscoveryGroupConfiguration, UDPBroadcastEndpointFactory}
import org.apache.activemq.artemis.api.jms.{ActiveMQJMSClient, JMSFactoryType}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.net.URI
import jakarta.jms.ConnectionFactory

@Component
class ArtemisJmsConnectionFactory(@Autowired artemisConfig: ArtemisConfig) extends BaseJmsConnectionFactory() {

  override protected def factory(): ConnectionFactory = taskQueueBrokerConfig match {
    case cfg: ExternalConfig if !inProcessTaskEngine =>
      val uri = new URI(cfg.url)
      val udpConfig = new UDPBroadcastEndpointFactory()
      udpConfig.setGroupAddress(uri.getHost).setGroupPort(uri.getPort)
      artemisConfig.localBindAddress.foreach(udpConfig.setLocalBindAddress)
      artemisConfig.localBindPort.foreach(udpConfig.setLocalBindPort)
      val discoveryGroupConfig = new DiscoveryGroupConfiguration
      discoveryGroupConfig.setBroadcastEndpointFactory(udpConfig)
      val factory = ActiveMQJMSClient.createConnectionFactoryWithHA(discoveryGroupConfig, JMSFactoryType.QUEUE_CF)
      factory.setUser(cfg.username)
      factory.setPassword(cfg.password)
      factory
    case _ => throw UnsupportedJmsConfigurationException(
      "Unsupported configuration: deploy.task.in-process-worker should be set to 'false' to use external broker."
    )
  }
}
