package com.xebialabs.xldeploy.jms.config

import org.springframework.beans.factory.annotation.Value
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class SpringArtemisConfig {

  @Value("${deploy.task.queue.external.artemis.local-bind-address}")
  var localBindAddress: String = _

  @Value("${deploy.task.queue.external.artemis.local-bind-port}")
  var localBindPortPath: Int = _

  @Bean
  def artemisConfig: ArtemisConfig = ArtemisConfig(Some(localBindAddress), Some(localBindPortPath))
}

case class ArtemisConfig(localBindAddress: Option[String], localBindPort: Option[Int])
