package com.xebialabs.xldeploy.status.queue

import com.xebialabs.deployit.core.events.dto.{ApplicationDeploymentPackageState, DeployedApplicationPackage}
import com.xebialabs.xldeploy.jms.adapter.DeploymentPackageStatusQueueNameResolver
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jms.core.JmsTemplate
import org.springframework.stereotype.Component

@Component
@Autowired
class DefaultDeploymentPackageStatusProducer(
                                              @Qualifier("taskPathStatusJmsTemplate") jmsTemplate: JmsTemplate,
                                              deploymentPackageStatusQueueNameResolver: DeploymentPackageStatusQueueNameResolver
                                            )
  extends DeploymentPackageStatusStore {

  override def sendDeployedApplicationPackageEvent(event: DeployedApplicationPackage): Unit =
    jmsTemplate.convertAndSend(deploymentPackageStatusQueueNameResolver.getDeploymentPackageStatusQueueName, event)

  override def sendDeploymentPackageStatusEvent(event: ApplicationDeploymentPackageState): Unit =
    jmsTemplate.convertAndSend(deploymentPackageStatusQueueNameResolver.getDeploymentPackageStatusQueueName, event)
}
