package com.xebialabs.xldeploy.jms.ws

import ai.digital.configuration.central.deploy.WebSocketsProperties
import com.xebialabs.deployit.core.events.{ChangeSetEvent, CiRef, JmsCiChangeSetEvent}
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, DeployedApplication}
import com.xebialabs.xldeploy.jms.adapter.CiQueueNameResolver
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jms.core.JmsTemplate
import org.springframework.security.core.context.SecurityContextHolder
import org.springframework.stereotype.Component

import java.util
import scala.jdk.CollectionConverters._

@Component
@Autowired
class WebSocketJmsBean(@Qualifier("notificationJmsTemplate") jmsTemplate: JmsTemplate,
                       ciQueueNameResolver: CiQueueNameResolver,
                       webSocketsProperties: WebSocketsProperties) {

  def sendChangeSetEvent(event: ChangeSetEvent): Unit =
    if (webSocketsProperties.enabled) {
      jmsTemplate.convertAndSend(ciQueueNameResolver.getCisChangedQueueName,
        JmsCiChangeSetEvent(
          toCiIds(event.createCis),
          event.copyCis.asScala.toList,
          event.deleteCiIds.asScala.toList,
          event.renameCis.asScala.toList,
          event.moveCis.asScala.toList,
          toCiIds(event.updateCis),
          getUsername
        ))
    }

  private def toCiIds(items: util.Collection[ConfigurationItem]): List[CiRef] =
    items.asScala.map {
      case d: DeployedApplication => CiRef(d.getId, d.getType.toString, d.getVersion.getVersion)
      case item: ConfigurationItem => CiRef(item.getId, item.getType.toString, null)
    }.toList

  private def getUsername: String = {
    Option(SecurityContextHolder.getContext.getAuthentication).map(_.getName).getOrElse("admin")
  }
}
