package com.xebialabs.xldeploy.jms.adapter

import com.rabbitmq.jms.client.RMQSession
import grizzled.slf4j.Logging
import jakarta.jms.Session
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.{Bean, Configuration}

import scala.jdk.CollectionConverters._

@Configuration
class MqSessionCustomizer {

  @ConditionalOnProperty(prefix = "deploy.task.queue.external", name = Array("rabbitmq.quorum-queue"), havingValue = "true")
  @Bean(Array("mqSessionArgsConfig"))
  def rmqQuorumSessionArgsConfig: QueueSessionCustomizer = new RMQQuorumQueueSessionCustomizer

  @ConditionalOnProperty(prefix = "deploy.task.queue.external", name = Array("rabbitmq.quorum-queue"), havingValue = "false", matchIfMissing = true)
  @Bean(Array("mqSessionArgsConfig"))
  def mqSessionArgsConfig: QueueSessionCustomizer = new DefaultQueueSessionCustomizer
}

trait QueueSessionCustomizer {
  def getUpdatedQueueSession(session: Session): Session
}

class DefaultQueueSessionCustomizer extends QueueSessionCustomizer {
  override def getUpdatedQueueSession(session: Session): Session = session
}

class RMQQuorumQueueSessionCustomizer extends QueueSessionCustomizer with Logging {
  override def getUpdatedQueueSession(session: Session): Session = {
    try {
      session match {
        case rabbitSession: RMQSession =>
          rabbitSession.setQueueDeclareArguments(Map("x-queue-type" -> "quorum".asInstanceOf[AnyRef]).asJava)
          rabbitSession
        case _ => session
      }
    } catch {
      case e: Exception =>
        logger.error(s"Exception occurred , $e")
        throw e
    }
  }
}
