package com.xebialabs.xldeploy.status.queue

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.concurrent.atomic.AtomicReference

object DeploymentPackageStatusStoreHolder {
  val deploymentPackageStatusStore = new AtomicReference[DeploymentPackageStatusStore]

  def getDeploymentPackageStatusStore: DeploymentPackageStatusStore = DeploymentPackageStatusStoreHolder.deploymentPackageStatusStore.get()
}

@Component
class DeploymentPackageStatusStoreHolder {
  @Autowired
  def this(deploymentPackageStatusStore: DeploymentPackageStatusStore) = {
    this()
    DeploymentPackageStatusStoreHolder.deploymentPackageStatusStore.set(deploymentPackageStatusStore)
  }
}
