package com.xebialabs.xldeploy.jms.adapter

import com.xebialabs.xldeploy.jms.factory.JmsConnectionFactory
import grizzled.slf4j.Logging
import javax.jms.ConnectionFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.jms.connection.{CachingConnectionFactory, SingleConnectionFactory}
import org.springframework.stereotype.Component

@Component
class JmsConnectionFactoryProvider(@Autowired jmsConnectionFactory: JmsConnectionFactory) extends Logging {

  def cachingConnectionFactory(): ConnectionFactory = {
    val cf = new CachingConnectionFactory()
    cf.setTargetConnectionFactory(jmsConnectionFactory.create())
    cf.setReconnectOnException(true)
    cf
  }

  def singleConnectionFactory(): ConnectionFactory = {
    val cf = new SingleConnectionFactory()
    cf.setTargetConnectionFactory(jmsConnectionFactory.create())
    cf.setReconnectOnException(true)
    cf
  }
}
