package com.xebialabs.xldeploy.jms.ws

import com.xebialabs.deployit.core.events.TaskPathStatusEvent
import com.xebialabs.xldeploy.jms.adapter.TaskPathStatusQueueNameResolver
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jms.core.JmsTemplate
import org.springframework.stereotype.Component

@Component
@Autowired
class TaskPathStatusJmsBean(@Qualifier("taskPathStatusJmsTemplate") jmsTemplate: JmsTemplate,
                            taskPathStatusQueueNameResolver: TaskPathStatusQueueNameResolver) {

  def sendChangeSetEvent(event: TaskPathStatusEvent): Unit = {
    jmsTemplate.convertAndSend(taskPathStatusQueueNameResolver.getTaskPathStatusQueueName, event)
  }
}
