/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.engine.tasker.OldExecutionContextListenerCleanupTrigger;
import com.xebialabs.deployit.local.message.ProductName;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.ITask;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.test.repository.InMemoryRepository;
import com.xebialabs.deployit.test.support.TestInspectionContext;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExecutionContext
implements ExecutionContext {
    private final Logger logger;
    private final Map<String, Object> attributes = Maps.newHashMap();
    private TestInspectionContext inspectionContext = new TestInspectionContext();
    private final Repository repository;

    public TestExecutionContext() {
        this((Repository)new InMemoryRepository());
    }

    public TestExecutionContext(Class<?> clazz) {
        this(clazz, (Repository)new InMemoryRepository());
    }

    public TestExecutionContext(Repository repository) {
        this.repository = repository;
        this.logger = LoggerFactory.getLogger(TestExecutionContext.class);
    }

    public TestExecutionContext(Class<?> clazz, Repository repository) {
        this.repository = repository;
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public void logOutput(String output) {
        this.logger.info(output);
    }

    public void logMsgOutput(ProductName productName, String key, Object ... args) {
        this.logger.info(this.getMessage(productName, key, args));
    }

    public void logError(String error) {
        this.logger.error(error);
    }

    public void logError(String error, Throwable t) {
        this.logger.error(error, t);
    }

    public Object getAttribute(String name) {
        Object attributeValue = this.attributes.get(name);
        if (attributeValue instanceof OldExecutionContextListenerCleanupTrigger) {
            attributeValue = ((OldExecutionContextListenerCleanupTrigger)attributeValue).getWrappedListener();
        }
        return attributeValue;
    }

    public void setAttribute(String name, Object value) {
        Object attributeValue = value;
        if (attributeValue instanceof ExecutionContextListener) {
            attributeValue = new OldExecutionContextListenerCleanupTrigger(name, (ExecutionContextListener)value);
        }
        this.attributes.put(name, attributeValue);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public TestInspectionContext getInspectionContext() {
        return this.inspectionContext;
    }

    public ITask getTask() {
        return new ITask(this){

            public String getId() {
                return "task-1";
            }

            public String getUsername() {
                return "admin";
            }

            public Map<String, String> getMetadata() {
                return new HashMap<String, String>();
            }
        };
    }

    public void clearInspectionContext() {
        this.inspectionContext = new TestInspectionContext();
    }

    public void destroy() {
        TaskExecutionStateEvent destroyEvent = new TaskExecutionStateEvent(this){

            public TaskExecutionState previousState() {
                return TaskExecutionState.EXECUTING;
            }

            public TaskExecutionState currentState() {
                return TaskExecutionState.EXECUTED;
            }

            public TaskWithSteps task() {
                return null;
            }
        };
        for (Object attr : this.attributes.values()) {
            if (!(attr instanceof ExecutionStateListener)) continue;
            ((ExecutionStateListener)attr).taskStateChanged(destroyEvent);
        }
        this.attributes.clear();
    }
}

