/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.local.message.ProductName;
import com.xebialabs.deployit.plugin.api.flow.ITask;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.test.repository.InMemoryRepository;
import com.xebialabs.deployit.test.support.TestExecutionContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

public class CapturingExecutionContext
extends TestExecutionContext {
    protected List<String> capturedOutput = Lists.newArrayList();
    protected List<String> capturedError = Lists.newArrayList();
    protected ITask task;

    public CapturingExecutionContext() {
        super((Repository)new InMemoryRepository());
    }

    public CapturingExecutionContext(Class<?> clazz) {
        super(clazz, (Repository)new InMemoryRepository());
    }

    public CapturingExecutionContext(Class<?> clazz, Repository repository) {
        super(clazz, repository);
    }

    public CapturingExecutionContext(Repository repository) {
        super(repository);
    }

    public CapturingExecutionContext(final String taskid, Class<?> clazz, Repository repository) {
        super(clazz, repository);
        this.task = new ITask(){

            public String getId() {
                return taskid;
            }

            public String getUsername() {
                return null;
            }

            public Map<String, String> getMetadata() {
                return null;
            }
        };
    }

    @Override
    public void logOutput(String output) {
        super.logOutput(output);
        this.capturedOutput.add(output);
    }

    @Override
    public void logMsgOutput(ProductName productName, String key, Object ... args) {
        String output = this.getMessage(productName, key, args);
        super.logOutput(output);
        this.capturedOutput.add(output);
    }

    @Override
    public void logError(String error) {
        super.logError(error);
        this.capturedError.add(error);
    }

    @Override
    public void logError(String error, Throwable t) {
        super.logError(error, t);
        this.capturedError.add(error);
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            this.capturedError.add(sw.toString());
        }
    }

    @Override
    public ITask getTask() {
        return this.task;
    }

    public List<String> getCapturedOutput() {
        return this.capturedOutput;
    }

    public List<String> getCapturedError() {
        return this.capturedError;
    }
}

