/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.test.support.ItestTopology;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.platform.test.TestUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployedItestChangeSet {
    private List<TestAction> tests = Lists.newArrayList();
    private TestAction deployMode = TestAction.CREATE;
    private Map<String, Deployed> create = Maps.newLinkedHashMap();
    private Map<String, Deployed> modify = Maps.newLinkedHashMap();
    private Map<String, Deployed> verifyCreate = Maps.newLinkedHashMap();
    private Map<String, Deployed> verifyModify = Maps.newLinkedHashMap();
    private List<Type> additionalTypesToDiscover = Lists.newArrayList();
    private Set<PropertyDescriptor> requiredForInspection = Sets.newHashSet();
    private File changesetXmlFile;
    private Container container;
    private ItestTopology topology;
    private TemporaryFolder folder;
    private static final Logger logger = LoggerFactory.getLogger(DeployedItestChangeSet.class);

    protected DeployedItestChangeSet(File changesetXmlFile, Container container, ItestTopology topology, TemporaryFolder folder) {
        this.changesetXmlFile = changesetXmlFile;
        this.container = container;
        this.topology = topology;
        this.folder = folder;
    }

    public static DeployedItestChangeSet loadChangeSet(File changesetXmlFile, Container container, ItestTopology topology, TemporaryFolder folder) throws JDOMException, IOException {
        DeployedItestChangeSet cs = new DeployedItestChangeSet(changesetXmlFile, container, topology, folder);
        cs.init();
        return cs;
    }

    protected void init() throws JDOMException, IOException {
        SAXBuilder sb = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        Document deployedProperties = sb.build(this.changesetXmlFile);
        Element rootElement = deployedProperties.getRootElement();
        this.setTests(rootElement.getAttributeValue("tests"));
        this.setDeployMode(rootElement.getAttributeValue("deployMode"));
        String disableInTopology = rootElement.getAttributeValue("disableInTopology");
        if (Strings.isNotBlank((String)disableInTopology)) {
            Iterable searchTags = Splitter.on((char)',').trimResults().split((CharSequence)disableInTopology);
            if (!this.topology.getTags().isEmpty()) {
                for (String searchTag : searchTags) {
                    if (!this.topology.getTags().contains(searchTag)) continue;
                    return;
                }
            }
        }
        List deployedGroupElements = rootElement.getChildren("deployeds");
        for (Element deployedGroupElement : deployedGroupElements) {
            String additionalTypes = deployedGroupElement.getAttributeValue("additionalTypesToDiscover");
            if (Strings.isNotBlank((String)additionalTypes)) {
                for (String t : additionalTypes.split(",")) {
                    this.addAdditionalTypeToDiscover(t);
                }
            }
            String target = deployedGroupElement.getAttributeValue("target");
            Container targetContainer = this.container;
            if (target != null) {
                Type containerType = Type.valueOf((String)target);
                if (!this.container.getType().instanceOf(containerType)) {
                    boolean alwaysDeployToTarget = "true".equals(deployedGroupElement.getAttributeValue("alwaysDeployToTarget"));
                    if (!alwaysDeployToTarget) continue;
                    targetContainer = this.topology.findFirstMatchingTarget(containerType);
                }
            }
            List deployedElements = deployedGroupElement.getChildren();
            File deployedFolder = this.folder.newFolder();
            for (Element each : deployedElements) {
                this.convertDeployedElementToDeployed(each, targetContainer, deployedFolder);
            }
        }
        this.associateDeployedIdsWithContainer();
    }

    protected void setTests(String testsString) {
        if (testsString == null || testsString.trim().isEmpty()) {
            return;
        }
        for (String s : testsString.split("[, ]+")) {
            try {
                this.tests.add(TestAction.valueOf(s.toUpperCase()));
            }
            catch (IllegalArgumentException exc) {
                throw new IllegalArgumentException(String.format("Unsupported tests value [%s] on itest tag, expected one of [%s]", s, Joiner.on((String)"|").join((Iterable)Lists.newArrayList((Object[])TestAction.values()))));
            }
        }
    }

    protected void setDeployMode(String deployModeAttribute) {
        if (deployModeAttribute == null || deployModeAttribute.trim().isEmpty()) {
            return;
        }
        try {
            this.deployMode = TestAction.valueOf(deployModeAttribute.toUpperCase());
        }
        catch (IllegalArgumentException exc) {
            throw new IllegalArgumentException(String.format("Unsupported deployMode value [%s] on itest tag expected [%s]", deployModeAttribute, Joiner.on((String)"|").join((Iterable)Lists.newArrayList((Object[])TestAction.values()))));
        }
    }

    private void convertDeployedElementToDeployed(Element elt, Container container, File deployedFolder) throws IOException {
        HashSet allowedAttributes = Sets.newHashSet((Object[])new String[]{"name", "id", "modification", "replace"});
        for (Attribute a : elt.getAttributes()) {
            if (allowedAttributes.contains(a.getName())) continue;
            throw new IllegalArgumentException(String.format("Unknown attribute %s", a.getName()));
        }
        String name = elt.getAttributeValue("name");
        if (name == null) {
            name = (String)Checks.checkNotNull((Object)elt.getAttributeValue("id"), (String)"Element [%s] has no [name] attribute", (Object[])new Object[]{elt.getName()});
            logger.warn("Using deprecated 'id' in [{}], instead of 'name' for element [{}].", (Object)this.changesetXmlFile, (Object)elt.getName());
        }
        boolean isModification = "true".equals(elt.getAttributeValue("modification"));
        boolean isReplace = "true".equals(elt.getAttributeValue("replace"));
        if (isReplace) {
            Checks.checkArgument((boolean)this.deployedToBeCreatedExists(name), (String)"Element [%s] has replace='true' but the original deployed with id [%s] could not be found.", (Object[])new Object[]{elt.getName(), name});
            this.addDeployedToModify(this.createDeployed(elt, container, deployedFolder, name, PropertyScope.DEPLOY));
            this.addDeployedToVerifyModify(this.createDeployed(elt, container, deployedFolder, name, PropertyScope.INSPECT));
        } else if (isModification) {
            Checks.checkArgument((boolean)this.deployedToBeCreatedExists(name), (String)"Element [%s] has modification='true' but the original deployed with id [%s] could not be found.", (Object[])new Object[]{elt.getName(), name});
            Deployed deployed = this.cloneDeployed(this.getDeployedToCreate(name));
            this.convertPropertyElementsToProperties(elt, (ConfigurationItem)deployed, PropertyScope.DEPLOY);
            this.addDeployedToModify(deployed);
            this.addDeployedToVerifyModify(deployed);
        } else {
            this.addDeployedToCreate(this.createDeployed(elt, container, deployedFolder, name, PropertyScope.DEPLOY));
            this.addDeployedToVerifyCreate(this.createDeployed(elt, container, deployedFolder, name, PropertyScope.INSPECT));
        }
    }

    private Deployed<?, Container> createDeployed(Element elt, Container container, File deployedFolder, String name, PropertyScope scope) throws IOException {
        Descriptor d = DescriptorRegistry.getDescriptor((String)elt.getName());
        Checks.checkArgument((boolean)d.isAssignableTo(Deployed.class), (String)"Type [%s] is not assignable to udm.Deployed", (Object[])new Object[]{d.getType()});
        Deployed deployed = (Deployed)d.newInstance(name);
        deployed.setContainer(container);
        if (deployed instanceof Artifact) {
            Element fileNameElm = elt.getChild("fileName");
            Checks.checkArgument((fileNameElm != null ? 1 : 0) != 0, (String)"Type [%s] is an artifact and must specify fileName that can be resolved from the classpath", (Object[])new Object[]{d.getType()});
            File artifact = new File(deployedFolder, OverthereUtils.getName((String)fileNameElm.getValue()));
            URL aURL = this.getClass().getClassLoader().getResource(fileNameElm.getValue());
            Resources.asByteSource((URL)aURL).copyTo(Files.asByteSink((File)artifact, (FileWriteMode[])new FileWriteMode[0]));
            ((Artifact)deployed).setFile(LocalFile.valueOf((File)artifact));
        }
        this.convertPropertyElementsToProperties(elt, (ConfigurationItem)deployed, scope);
        Deployable deployable = this.createDeployableFromDeployed(deployed);
        deployed.setDeployable(deployable);
        return deployed;
    }

    private void convertPropertyElementsToProperties(Element elt, ConfigurationItem deployed, PropertyScope scope) throws IOException {
        Descriptor d = deployed.getType().getDescriptor();
        block8: for (Element p : elt.getChildren()) {
            if (p.getName().equals("fileName")) continue;
            PropertyDescriptor pd = (PropertyDescriptor)Checks.checkNotNull((Object)d.getPropertyDescriptor(p.getName()), (String)"Property [%s] does not exist on type [%s]", (Object[])new Object[]{p.getName(), deployed.getType()});
            if (p.getAttributeValue("inspectionProperty") != null && p.getAttributeValue("inspectionProperty").equals("true")) {
                this.requiredForInspection.add(pd);
            }
            if (!this.getScope(p).contains((Object)scope)) continue;
            switch (pd.getKind()) {
                case CI: {
                    pd.set(deployed, (Object)this.resolveCiReference(p, pd));
                    continue block8;
                }
                case MAP_STRING_STRING: {
                    HashMap map = Maps.newHashMap();
                    for (Element e : p.getChildren("entry")) {
                        map.put(Objects.requireNonNull(e.getAttributeValue("key")), Objects.requireNonNull(e.getValue()));
                    }
                    pd.set(deployed, (Object)map);
                    continue block8;
                }
                case SET_OF_STRING: {
                    Element e;
                    HashSet setOfString = Sets.newHashSet();
                    e = p.getChildren("value").iterator();
                    while (e.hasNext()) {
                        Element v = (Element)e.next();
                        setOfString.add(v.getValue());
                    }
                    pd.set(deployed, (Object)setOfString);
                    continue block8;
                }
                case LIST_OF_STRING: {
                    ArrayList listOfString = Lists.newArrayList();
                    for (Element v : p.getChildren("value")) {
                        listOfString.add(v.getValue());
                    }
                    pd.set(deployed, (Object)listOfString);
                    continue block8;
                }
                case LIST_OF_CI: {
                    ArrayList listOfCi = Lists.newArrayList();
                    this.convertCiCollection(deployed, p, pd, listOfCi, scope);
                    continue block8;
                }
                case SET_OF_CI: {
                    HashSet setOfCi = Sets.newHashSet();
                    this.convertCiCollection(deployed, p, pd, setOfCi, scope);
                    continue block8;
                }
            }
            pd.set(deployed, (Object)(p.getAttributeValue("null") != null ? null : p.getValue()));
        }
    }

    protected List<PropertyScope> getScope(Element property) {
        if (property == null) {
            return null;
        }
        String scope = property.getAttributeValue("on");
        if (scope == null || scope.trim().isEmpty()) {
            return Arrays.asList(PropertyScope.DEPLOY, PropertyScope.INSPECT);
        }
        ArrayList<PropertyScope> values = new ArrayList<PropertyScope>(2);
        for (String s : scope.split("[, ]+")) {
            try {
                values.add(PropertyScope.valueOf(s.toUpperCase()));
            }
            catch (IllegalArgumentException exc) {
                throw new IllegalArgumentException(String.format("Unsupported value [%s] on scope tag, expected one of [%s]", s, Joiner.on((String)"|").join((Iterable)Lists.newArrayList((Object[])PropertyScope.values()))));
            }
        }
        return values;
    }

    private void convertCiCollection(ConfigurationItem deployed, Element p, PropertyDescriptor pd, Collection<ConfigurationItem> cis, PropertyScope scope) throws IOException {
        if (pd.isAsContainment()) {
            List embeddeds = p.getChildren();
            for (Element ee : embeddeds) {
                String name = (String)Checks.checkNotNull((Object)ee.getAttributeValue("name"), (String)"Element [%s] has no [name] attribute", (Object[])new Object[]{ee.getName()});
                Descriptor ed = DescriptorRegistry.getDescriptor((String)ee.getName());
                Checks.checkArgument((boolean)ed.isAssignableTo(EmbeddedDeployed.class), (String)"Type [%s] is not assignable to udm.EmbeddedDeployed", (Object[])new Object[]{ed.getType()});
                EmbeddedDeployed embeddedDeployed = (EmbeddedDeployed)ed.newInstance(deployed.getId() + "/" + name);
                this.convertPropertyElementsToProperties(ee, (ConfigurationItem)embeddedDeployed, scope);
                embeddedDeployed.setContainer((ConfigurationItem)((EmbeddedDeployedContainer)deployed));
                cis.add((ConfigurationItem)embeddedDeployed);
            }
        } else {
            for (Element v : p.getChildren("value")) {
                cis.add(this.resolveCiReference(v, pd));
            }
        }
        pd.set(deployed, cis);
    }

    protected ConfigurationItem resolveCiReference(Element p, PropertyDescriptor pd) {
        String ciRefId = p.getValue().trim();
        if (this.deployedToBeCreatedExists(ciRefId)) {
            return this.getDeployedToCreate(ciRefId);
        }
        ciRefId = this.topology.replacePlaceholders(ciRefId);
        ConfigurationItem ciRef = this.topology.getItems().get(ciRefId);
        if (ciRef == null) {
            ciRef = DescriptorRegistry.getDescriptor((Type)pd.getReferencedType()).newInstance(ciRefId);
        }
        return ciRef;
    }

    private Deployable createDeployableFromDeployed(Deployed<?, Container> deployed) {
        Descriptor deployedDesc = deployed.getType().getDescriptor();
        Descriptor deployableDesc = deployedDesc.getDeployableType().getDescriptor();
        if (deployableDesc.isVirtual()) {
            Type instantiableDeployable = (Type)Iterables.find((Iterable)DescriptorRegistry.getSubtypes((Type)deployableDesc.getType()), (Predicate)new Predicate<Type>(){

                public boolean apply(Type subType) {
                    return !subType.getDescriptor().isVirtual();
                }
            }, null);
            Checks.checkNotNull((Object)instantiableDeployable, (String)"Unable to find instantiable subtype of virtual type %s. Please check your CI definitions.", (Object[])new Object[]{deployableDesc.getType().getName()});
            deployableDesc = instantiableDeployable.getDescriptor();
        }
        return (Deployable)deployableDesc.newInstance(deployed.getId());
    }

    protected void associateDeployedIdsWithContainer() {
        Iterable deployeds = Iterables.concat(this.getDeployedsToCreate(), this.getDeployedsToModify(), this.getDeployedsToVerifyCreate(), this.getDeployedsToVerifyModify());
        for (Deployed deployed : deployeds) {
            Objects.requireNonNull(deployed.getContainer());
            deployed.setId(deployed.getContainer().getId() + "/" + deployed.getId());
        }
    }

    protected List<Deployed> cloneForInspection(List<Deployed> deployeds) {
        ArrayList clonedDeployeds = Lists.newArrayList();
        for (Deployed deployed : deployeds) {
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed.getType());
            Deployed c = (Deployed)descriptor.newInstance(deployed.getId());
            Iterable inspectProperties = Iterables.filter((Iterable)descriptor.getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

                public boolean apply(PropertyDescriptor input) {
                    return input.isInspectionProperty() || DeployedItestChangeSet.this.requiredForInspection.contains(input);
                }
            });
            c.setDeployable(deployed.getDeployable());
            c.setContainer(deployed.getContainer());
            for (PropertyDescriptor inspectProperty : inspectProperties) {
                inspectProperty.set((ConfigurationItem)c, inspectProperty.get((ConfigurationItem)deployed));
            }
            clonedDeployeds.add(c);
        }
        return clonedDeployeds;
    }

    protected Deployed cloneDeployed(Deployed<?, Container> deployed) {
        Deployed clonedDeployed = (Deployed)TestUtils.newInstance((Type)deployed.getType(), (String)deployed.getId());
        clonedDeployed.setDeployable(deployed.getDeployable());
        clonedDeployed.setContainer(deployed.getContainer());
        for (PropertyDescriptor inspectProperty : deployed.getType().getDescriptor().getPropertyDescriptors()) {
            inspectProperty.set((ConfigurationItem)clonedDeployed, inspectProperty.get(deployed));
        }
        try {
            Method getFile = deployed.getClass().getMethod("getFile", new Class[0]);
            Method setFile = clonedDeployed.getClass().getMethod("setFile", OverthereFile.class);
            setFile.invoke((Object)clonedDeployed, getFile.invoke(deployed, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clonedDeployed;
    }

    public List<TestAction> getTests() {
        return this.tests;
    }

    public TestAction getDeployMode() {
        return this.deployMode;
    }

    public List<Type> getAdditionalTypesToDiscover() {
        return this.additionalTypesToDiscover;
    }

    public boolean hasDeployedsToCreate() {
        return !this.create.isEmpty();
    }

    public boolean hasDeployedsToModify() {
        return !this.modify.isEmpty();
    }

    public void addAdditionalTypeToDiscover(String type) {
        this.additionalTypesToDiscover.add(Type.valueOf((String)type.trim()));
    }

    public void addDeployedToCreate(Deployed d) {
        this.create.put(d.getId(), d);
    }

    public void addDeployedToVerifyCreate(Deployed d) {
        this.verifyCreate.put(d.getId(), d);
    }

    public void addDeployedToModify(Deployed d) {
        this.modify.put(d.getId(), d);
    }

    public void addDeployedToVerifyModify(Deployed d) {
        this.verifyModify.put(d.getId(), d);
    }

    public Deployed getDeployedToCreate(String id) {
        return this.create.get(id);
    }

    public Deployed getDeployedToModify(String id) {
        return this.modify.get(id);
    }

    public boolean deployedToBeCreatedExists(String id) {
        return this.create.containsKey(id);
    }

    public List<Deployed> getDeployedsToCreate() {
        return Lists.newArrayList(this.create.values());
    }

    public List<Deployed> getDeployedsToVerifyCreate() {
        return Lists.newArrayList(this.verifyCreate.values());
    }

    public List<Deployed> getDeployedsToVerifyModify() {
        return Lists.newArrayList(this.verifyModify.values());
    }

    public List<Deployed> getDeployedsToModify() {
        return Lists.newArrayList(this.modify.values());
    }

    public static enum PropertyScope {
        DEPLOY,
        INSPECT;

    }

    public static enum TestAction {
        VERIFYABSENCE,
        CREATE,
        VERIFYCREATE,
        MODIFY,
        VERIFYMODIFY,
        DESTROY,
        VERIFYDESTROY,
        NOOP;

    }
}

