/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.LoggerFactory;

public class LogbackEventsCapture
implements TestRule {
    private static List<Matcher<Iterable<? super ILoggingEvent>>> matchers = new ArrayList<Matcher<Iterable<? super ILoggingEvent>>>();
    private String loggerName;
    private Level level;
    private boolean debug;

    public LogbackEventsCapture(String loggerName) {
        this(loggerName, Level.TRACE, false);
    }

    public LogbackEventsCapture(String loggerName, Level level) {
        this(loggerName, level, false);
    }

    public LogbackEventsCapture(String loggerName, Level level, boolean debug) {
        this.loggerName = loggerName;
        this.level = level;
        this.debug = debug;
    }

    public void containsMessageWith(String expectedMsg) {
        this.assertThatEvents((Matcher<Iterable<? super ILoggingEvent>>)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"message", (Matcher)CoreMatchers.containsString((String)expectedMsg))));
    }

    public void doesntContainMessageWith(String rawMsg) {
        this.assertThatEvents((Matcher<Iterable<? super ILoggingEvent>>)CoreMatchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"message", (Matcher)CoreMatchers.containsString((String)rawMsg)))));
    }

    public void assertThatEvents(Matcher<Iterable<? super ILoggingEvent>> matcher) {
        matchers.add(matcher);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ListAppender appender = new ListAppender();
                Logger scriptsLogger = (Logger)LoggerFactory.getLogger((String)LogbackEventsCapture.this.loggerName);
                scriptsLogger.setLevel(LogbackEventsCapture.this.level);
                scriptsLogger.addAppender((Appender)appender);
                appender.start();
                try {
                    base.evaluate();
                }
                finally {
                    List events = appender.list;
                    if (!matchers.isEmpty()) {
                        if (LogbackEventsCapture.this.debug) {
                            this.dumpEvents(events);
                        }
                        try {
                            for (Matcher<Iterable<? super ILoggingEvent>> matcher : matchers) {
                                MatcherAssert.assertThat((Object)events, matcher);
                            }
                        }
                        finally {
                            matchers.clear();
                            appender.stop();
                            events.clear();
                        }
                    }
                }
            }

            private void dumpEvents(List<ILoggingEvent> events) {
                StringBuilder sb = new StringBuilder();
                String NL = System.getProperty("line.separator");
                for (ILoggingEvent event : events) {
                    sb.append(event.getLevel()).append(":").append(event.getMessage()).append(NL);
                }
                System.err.print(sb.toString());
            }
        };
    }
}

