package com.xebialabs.deployit.test.deployment;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;

import static com.xebialabs.deployit.server.api.util.IdGenerator.generateId;

public final class DeltaSpecifications {

    private DeltaSpecifications() {}

    public static DeployedApplication createDeployedApplication(Version version, Environment environment) {
        String id = generateId(environment.getId(), version.getApplication().getId());
        DeployedApplication deployedApplication = Type.valueOf(DeployedApplication.class).getDescriptor().newInstance(id);
        deployedApplication.setVersion(version);
        deployedApplication.setEnvironment(environment);
        return deployedApplication;
    }

}
