package com.xebialabs.deployit.deployment.planner;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecificationWithDependencies;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;

import static com.xebialabs.deployit.plugin.api.deployment.specification.Operation.*;

public final class MultiDeltaSpecificationHelper {

    private MultiDeltaSpecificationHelper() {}

    private static Map<Operation, Integer> operationWeight = ImmutableMap.of(
            DESTROY, 4,
            MODIFY, 3,
            CREATE, 2,
            NOOP, 1);

    private static BinaryOperator<Operation> pickCommonOperation = (operation, operation2) -> {
        if (operationWeight.get(operation) >= operationWeight.get(operation2)) {
            return operation;
        } else {
            return operation2;
        }
    };


    public static DeployedApplication correctDeployedApplication(DeltaSpecification deltaSpecification) {
        if (deltaSpecification.getDeployedApplication() == null) {
            return deltaSpecification.getPreviousDeployedApplication();
        } else {
            return deltaSpecification.getDeployedApplication();
        }
    }

    public static Optional<Operation> commonOperation(List<DeltaSpecification> allDeltaSpecifications) {
        return allDeltaSpecifications.stream().map(DeltaSpecification::getOperation).reduce(pickCommonOperation);
    }

    public static String applicationNames(DeltaSpecificationWithDependencies deltaSpecificationWithDependencies) {
        return deltaSpecificationWithDependencies.getAllDeltaSpecifications().stream()
                .map(MultiDeltaSpecificationHelper::correctDeployedApplication)
                .map(DeployedApplication::getName).collect(Collectors.joining(", "));
    }
}
