package com.xebialabs.deployit.deployment.orchestrator

import com.xebialabs.deployit.deployment.orchestrator.DescriptionHelper._
import com.xebialabs.deployit.engine.spi.orchestration.Orchestration
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations._
import com.xebialabs.deployit.plugin.api.deployment.specification.{DeltaSpecification, DeltaSpecificationWithDependencies}

import scala.jdk.CollectionConverters._

class DefaultOrchestrator extends OrchestratorUtil {
  def orchestrate(specification: DeltaSpecification): Orchestration = interleaved(getDescriptionForSpec(specification), specification.getDeltas)

  def orchestrate(specs: DeltaSpecificationWithDependencies): Orchestration = {
    interleaved(getDescriptionForSpecWithDependencies(specs), mergeDeltas(specs).asJava)
  }
}
